path "D:\\BIN\\GSTUDIO6\\template";	// Path to WDL templates subdirectory

include <movement.wdl>;

var video_mode = 6;	 // screen size 640x480
var video_depth = 16; // 16 bit colour D3D mode

string level_str=<word.wmb>;
string word_of_power_picture=<word.bmp>;

bmap light=<light.bmp>;
bmap dark=<dark.bmp>;

function main()
{
	level_load(level_str);
}

function make_me_look_good()
{
	me.transparent=on;
	me.alpha=80;
	me.ambient=100;
	me.bright=on;
	me.oriented=on;
}

function make_energy_particle_look_good()
{
	me.move=on;
	me.bright=on;
	me.transparent=on;
	me.alpha=60;
}

//===========================================
var speed=10;
var fade_speed=1;
function move_random_direction()
{
	me.vel_x=random(speed)-speed/2;
	me.vel_y=random(speed)-speed/2;
	me.vel_z=random(speed)-speed/2;
}
function fade()
{
	me.alpha-=fade_speed*time;
	me.size+=0.3*fade_speed*time;
	if (me.alpha<0)
	{
		me.lifespan=0;
	}
}
function darkness()
{
	me.bmap=dark;
	make_energy_particle_look_good();
	move_random_direction();
	me.function=fade;
}
//======================================

var distance=500;
function move_away()
{
	me.x=you.x+random(distance)-distance/2;
	me.y=you.x+random(distance)-distance/2;
	me.z=you.z+random(distance)-distance/2;
	vec_set(me.vel_x,you.x);				
	vec_sub(me.vel_x,me.x);		//Creates a vector pointing towards the word of power
	vec_normalize(me.vel_x,5);	//Makes this vector length of 5, otherwise, the speed can vary
}
function grow()
{
	me.alpha+=fade_speed*time;
	me.size-=0.3*fade_speed*time;
	me.size=abs(me.size);
	if(vec_dist(me.x,you.x)<10) 
	{
		me.lifespan=0;
	}
}
function lightness()
{
	me.bmap=light;
	make_energy_particle_look_good();
	me.size=20;
	me.alpha=0;
	move_away();
	me.function=grow;
}

//==============================================
function animate_word()
{
	make_me_look_good();
	while(1)
	{
		effect(darkness,10*time,me.x,nullvector);
		effect(lightness,10*time,me.x,nullvector);
		wait(1);
	}
}

action spell_location()
{
	me.visible=off;
	ent_create(word_of_power_picture,me.x,animate_word);
}	