// Template file v4.23a (02/09/01)   @020901a
////////////////////////////////////////////////////////////////////////
// File: messages.wdl
//		WDL prefabs for displaying messages
////////////////////////////////////////////////////////////////////////
// Mod Date: 10/31/00 DCP
//				Changed to 4.30 format
//
////////////////////////////////////////////////////////////////////////
//
////////////////////////////////////////////////////////////////////////
IFNDEF MSG_DEFS;
 FONT standard_font,<ackfont.pcx>,6,9;

 DEFINE MSG_X,4;		// from left
 DEFINE MSG_Y,4;		// from above
 DEFINE BLINK_TICKS,6;	// msg blinking period
 DEFINE MSG_TICKS,64;	// msg appearing time
 DEFINE msg_font,standard_font;
 SOUND msg_sound,<msg.wav>;

 DEFINE PANEL_POSX,4;	// health panel from left
 DEFINE PANEL_POSY,-20;	// from below
 FONT digit_font,<digfont.pcx>,12,16;	// ammo/health font
ENDIF;

IFNDEF MSG_DEFS2;
 DEFINE SCROLL_X,4;		// scroll text from left
 DEFINE SCROLL_Y,4;		// from above
 DEFINE SCROLL_LINES,4;	// maximum 8;
ENDIF;

IFNDEF MSG_DEFS3;
 DEFINE HEALTHPANEL,game_panel;	// default health/ammo panel

 DEFINE touch_font,standard_font;
 DEFINE touch_sound,msg_sound;
ENDIF;

//////////////////////////////////////////////////////////////////////
var msg_counter = 0;
STRING empty_str,
 "                                                                    ";
STRING temp_str,
 "                                                                    ";

TEXT msg
{
	POS_X MSG_X;
	POS_Y MSG_Y;
	FONT	msg_font;
	STRING empty_str;
}

//////////////////////////////////////////////////////////////////////
// To display a message string for 5 seconds, perform the instructions
// msg.STRING = message_string; show_message();

function show_message()
{
//	ME = NULL;		// prevent stopping action by removing an entity
	EXCLUSIVE_GLOBAL;		// stop previous show_message action
	play_sound(msg_sound,66);
	msg.VISIBLE = ON;
	waitt(MSG_TICKS);
	msg.STRING = empty_str;
	msg.VISIBLE = OFF;
}

// The same, but message will blink
function blink_message()
{
//	ME = NULL;
	EXCLUSIVE_GLOBAL;
	play_sound(msg_sound,66);
	msg_counter = MSG_TICKS;
	while(msg_counter > 0)
	{
		if(msg.VISIBLE == ON)
		{
			msg.VISIBLE = OFF;
		}
		else
		{
			msg.VISIBLE = ON;
		}
		waitt(BLINK_TICKS);
		msg_counter -= BLINK_TICKS;
	}
	msg.STRING = empty_str;
	msg.VISIBLE = OFF;
}


//////////////////////////////////////////////////////////////////////
// actions for scrolling messages
//////////////////////////////////////////////////////////////////////
STRING message_str,
 "                                                                    ";
TEXT enter_txt
{
	FONT	msg_font;
	STRING message_str;
}

TEXT scroll
{
	POS_X MSG_X;
	POS_Y MSG_Y;
	FONT	msg_font;
	STRINGS 8;
	STRING "                                                           ";
	STRING "                                                           ";
	STRING "                                                           ";
	STRING "                                                           ";
	STRING "                                                           ";
	STRING "                                                           ";
	STRING "                                                           ";
	STRING "                                                           ";
	INDEX SCROLL_LINES;
}

SYNONYM scroll_string { TYPE STRING; }

// Desc: scroll message upwards while adding a line
// Mod Date: 11/28/00 JCL
//				Rewrite
function scroll_message()
{
	play_sound(msg_sound,66);
	scroll.VISIBLE = ON;
	temp = 1;
	while(temp <= SCROLL_LINES)
	{
		// scroll upwards by copying each string to the previous one
		str_cpy(scroll.STRING[temp-1],scroll.STRING[temp]);
		temp += 1;
	}
	// clear the last string
	str_cpy(scroll.STRING[SCROLL_LINES],empty_str);
}

STRING joined_str," joined";

function msg_join()
{
	str_cpy(temp_str,MESSAGE);
	str_cat(temp_str,joined_str);
	str_cpy(scroll.STRING[SCROLL_LINES],temp_str);
	scroll_message();
}

SYNONYM message_syn { TYPE STRING; DEFAULT message_str; }

function msg_string()
{
	if(MY_STRING == message_syn)
	{ // synonyms may be compared directly
		str_cpy(scroll.STRING,message_str);
		scroll_message();
		str_cpy(message_str,empty_str);
	}
}

ACTION enter_message
{
	enter_txt.VISIBLE = ON;
	enter_txt.POS_X = scroll.POS_X;
	enter_txt.POS_Y = scroll.POS_Y + (SCROLL_LINES-1) * scroll.CHAR_Y;
	inkey(message_str);
	if(RESULT == 13)
	{
 		send_string(message_str);
	}
	str_cpy(message_str,empty_str);
	enter_txt.VISIBLE = OFF;
}


//////////////////////////////////////////////////////////////////////
// actions for ammo and health panels
//////////////////////////////////////////////////////////////////////
var show_ammo = 0;
var show_health = 0;
var show_armor = 0;
var ammo_number = 0;
var ammo1 = 0;
var ammo2 = 0;
var ammo3 = 0;
var ammo4 = 0;

PANEL game_panel
{
	POS_X		PANEL_POSX;
	DIGITS	0,0,3,digit_font,1,show_ammo;
	DIGITS	40,0,3,digit_font,1,show_health;
//	DIGITS	80,0,3,digit_font,1,show_armor;
	FLAGS		TRANSPARENT,REFRESH;
}

//////////////////////////////////////////////////////////////////////
function show_panels()
{
	HEALTHPANEL.VISIBLE = ON;
	while(1)
	{	// forever
		HEALTHPANEL.POS_Y = SCREEN_SIZE.Y + PANEL_POSY;
		if(ammo_number == 0) { show_ammo = 0; }
		if(ammo_number == 1) { show_ammo = ammo1; }
		if(ammo_number == 2) { show_ammo = ammo2; }
		if(ammo_number == 3) { show_ammo = ammo3; }
		if(ammo_number == 4) { show_ammo = ammo4; }
		if(player != NULL)
		{
			show_health = player._HEALTH;
			show_armor = player._ARMOR;
		}
		wait(1);
	}
}

//////////////////////////////////////////////////////////////////////
// Stuff for displaying object titles if the mouse touches them
TEXT touch_txt
{
	FONT	touch_font;
	STRING empty_str;
	FLAGS CENTER_X,CENTER_Y;
}

// Desc: display a touch text at mouse position
function _show_touch()
{
	if(MY.STRING1 != NULL)
	{
		play_sound(touch_sound,33);
		touch_txt.VISIBLE = ON;
		touch_txt.STRING = MY.STRING1;
		touch_txt.POS_X = MOUSE_POS.X;
		touch_txt.POS_Y = MOUSE_POS.Y;
		MY.ENABLE_RELEASE = ON;

	//	WHILE (touch_text.VISIBLE == ON)	// move text with mouse
	//	{
	//		touch_text.POSX = MOUSE_X;
	//		touch_text.POSY = MOUSE_Y;
	//		wait(1);
	//	}
	}
}

// Desc: hide touch text if it still displayed my string
function _hide_touch()
{
	if(touch_txt.STRING == MY.STRING1)
	{
		touch_txt.VISIBLE = OFF;
	}
}

// Desc: call this from a event action to operate the touch text
function handle_touch()
{
	if(EVENT_TYPE == EVENT_TOUCH) { BRANCH _show_touch; }
	if(EVENT_TYPE == EVENT_RELEASE) { BRANCH _hide_touch; }
}

//////////////////////////////////////////////////////////////////////

IFDEF ACKNEX_VERSION414;
ON_JOIN	msg_join;
ON_STRING msg_string;
ON_F4 enter_message;
ENDIF;