// Template file v4.23a (02/09/01)   @020901a
//
// Last Mod: 02/11/01
////////////////////////////////////////////////////////////////////////
// File: movement.wdl
//		WDL prefabs for entity movement
////////////////////////////////////////////////////////////////////////
// Mod Date: 6/5/00
// Added code to handle new animation
// Player can now stand, walk, run, duck, jump, crawl, swim, and wade
//
// Mod Date: 6/8/00
// Converted code to 4.187 format (removed SETs and CALLs)
//
// Mod Date: 6/19/00
// Added __FALL (FLAG1) and _FALLTIME (SKILL31)
// If __FALL is ON, player takes damage from falls
// _FALLTIME contains the amount of time spent falling (calculated in move_gravity)
//
// Mod Date: 7/18/00
//	Changed slope gravity (added var 'slopefac')
//
// Mod Date: 7/19/00
// Added code to adjust my_height while ducking and crawling
//		- Add var 'duck_height'
//		- modified var 'eye_height_duck' to equal 'eye_height_up'
//
// Mod Date: 7/28/00
// Added __DUCK flag as flag #8 (replaces __SOUND flag)
// Player can only duck if the __DUCK flag is set to ON
//
// Mod Date: 8/28/00 DCP
//	Removed Actions 'player_heli' and 'player_fly' (experimental code)
//	Added MODEs _MODE_PLANE &  _MODE_CHOPPER
//	Expanded var 'camera_dist' & 'temp_cdist' into vectors (X,Y,Z fields)
// Modified 'move_view_3rd' FUNCTION to take advantage of 'camera_dist' vector
// Replaced min with max (to eliminate 'creep') in 'gravity' functions
//
// Mod Date: 8/31/00 DCP
//	Added movement_scale and actor_scale to scale movement and models (to make world appear larger or smaller)
// Modified "swim_gravity" to scale dist and absdist by movement_scale before MOVE
// Modified "wade_gravity" to scale dist and absdist by movement_scale before MOVE
// Modified "move_gravity" to scale dist and absdist by movement_scale before MOVE
// Modified function "anim_init" to use actor_scale to scale the entity that calls it.
// Modified 'walk_or_run' by 'movement_scale' in function "actor_anim"
//
// Mod Date: 9/2/00 DCP
//	Modified 'move_view_3rd' to set camera_dist.Z to player.MAX_Z if zero
//
// Mod Date: 10/31/00 DCP
//	Modified 'player_move':	Replaced min with max in ASPEED (to eliminate 'creep')
//	Changed to 4.30 format
//
// Mod Date: 11/8/00 DCP
//	Modified 'camera_move':	Replace move_view with a simple vec_add()
// Modified 'actor_anim': Replace set_frame and set_cycle with ent_frame and ent_cycle
//
// Mod Date: 11/9/00 DCP
//	Modified 'move_shadow': Replaced sonar with trace()
// Modified 'scan_floor': Replaced sonar with trace()
// Modified 'move_gravity': Replaced the double MOVE with a single MOVE and a distance check
// Modified 'swim_gravity': Change diving (player no longer rotates)
//
// Mod Date: 11/13/00 DCP
//	Added 'mouse_to_level': uses trace() and vec_for_screen() to set TARGET
//								to the nearest point under the cursor.
// Modified 'move_view_1st': Headwave only when 'on_passable_' && swimming
//
// Mod Date: 01/16/01 JCL
//	"swim_gravity", "wade_gravity", & "move_gravity"
//	Removed absdist movement_scale because absdist is calculated from external forces
//
// Mod Date: 02/02/01 JCL
//	Added function 'attach_entity': attaches an entity that has the same origin and the same frame cycles
//
// Mod Date: 02/07/01 DCP
// "move_view_1st": Check camera 'content' for swimming headbob (don't bob if
//			          underwater, do if swimming on top)
//				 		  Removed swimming 'eye_height_down' value
//				 		  Change formating, grouped like actions together
// "move_view_3rd": Adjusted eye height
// 					  Don't tilt camera if swimming
//
// Replace 'eye_height_down' with 'eye_height_swim'
//
// Mod Date: 02/08/01 DCP
// "scan_floor": Modified 'offset sonar' to calculate height when in water (no
//			longer uses the hull, assume swim animation is centered vertically).
//
// Mod Date: 02/09/01 DCP
//	"swim_gravity": Added code to 'surface' section that allows the player to 'hop' out of the water.
//	"player_move":	If entering passable block stop falling (MY._SPEED_Z = 0)
//
// Mod Date: 02/11/01 DCP
//	Added new var "my_height_passable".  This is the height of the player model's center
//  above any passable surface. It is only valid is the player model is in or on a passable surface.
//  It is set in "scan_floor" and used in "player_move" & "swim_gravity".
////////////////////////////////////////////////////////////////////////
//
////////////////////////////////////////////////////////////////////////

// Some definitions
// Change them by re-defining them in your main wdl script
// BEFORE the include, and adding DEFINE MOVE_DEFS;
IFNDEF MOVE_DEFS;
	SOUND  thud,<tap.wav>;
	SOUND  robo_thud,<gate.wav>;
	SOUND  splash,<splash.wav>;
	DEFINE shadowsprite,<shadow.pcx>;
	DEFINE shadowflat,<shadflat.pcx>;
	DEFINE DEFAULT_WALK,13.040;
	DEFINE DEFAULT_RUN,5.060;
ENDIF;


////////////////////////////////////////////////////////////////////////
// Some global skill definitions
// Duplicate them in your wdl script AFTER the include
// to give them new values
var movement_scale = 1.00;  // used to scale the movement
var actor_scale = 1.00;	// used to scale the size of actors

// NOTE: in most cases it is a good idea to make actor_scale == movement_scale

var gnd_fric = 0.5;		// ground friction
var air_fric = 0.03; 	// air friction
var water_fric = 0.75;	// water friction
var ang_fric = 0.6;		// angular friction
var gravity = 6; 			// gravity force
var elasticity = 0.1; 	// of the floor
var strength[3] = 5,4,75;	// default ahead, side, jump strength   (25)
var astrength[3] = 7,5,2;	// default pan, tilt, roll strength

var slopefac = 2; // gravity on slopes, determines the max angle to climb

var eye_height_up = 0.8;	// eye position factor for walking, driving
var eye_height_swim = 0.7;	// first person camera offset for swimming
var eye_height_duck = 0.8; // first person camera offset for ducking (7/19/00: same as eye_height_up since ducking is controlled by my_height)

var walk_rate = 3; 	// for head wave, 360 / step width
var wave_rate = 25; 	// same for swimming, 360 / wave time
var walk_ampl = 4;	// walking head wave amplitude
var wave_ampl = 2; 	// swimming head wave amplitude

var anim_attack_ticks = 16;// time for one attack animation cycle

var anim_stand_ticks = 16;	// time for one standing anim cycle
var anim_jump_ticks = 6; 	// time for one jump animation cycle
var anim_duck_ticks = 8; 	// time for one duck animation cycle

var anim_walk_dist = 1; 	// dist per model width per walk cycle
var anim_run_dist = 1.5;	// dist per model width per run cycle
var anim_crawl_dist = 0.8; // dist per model width per crawl cycle
var anim_wade_dist = 0.8;	// dist per model width per crawl cycle
var anim_swim_dist = 1; 	// dist per model width per swim cycle

var person_3rd	= 0;		// 0: 1st person mode; 0.5: 3rd person mode
//var camera_dist = 90;   // camera distance to entity in 3rd person view
var camera_dist[3] = 90,0,0;   // camera distance to entity in 3rd person view
var mouseview = 1;  		// mouse factor, set 0 to disable mouse
var client_moving = 0; 	// multiplayer mode

var jump_height = 50; 	// maximum jump height above ground
var fall_time = 6;		// max fall time before health is reduced
var duck_height = 25;	// distance to adjust my_height while ducking
var walk_or_run = 12; 	// max quants per tick to switch from walk to run animation

var power_max = 1; 		// maximum engine power for aircraft


// values set in scan_floor
var on_passable_;
var in_passable_;
var in_solid_;


// strings for defining the animation frames
STRING anim_stand_str,"stand";
STRING anim_walk_str,"walk";
STRING anim_run_str,"run";
STRING anim_duck_str,"duck";
STRING anim_swim_str,"swim";
STRING anim_dive_str,"dive";
STRING anim_jump_str,"jump";
STRING anim_crawl_str,"crawl";
STRING anim_wade_str,"walk";

// string synonyms for defining the animation frames (and their default values)
STRING anim_default_death_str,"death";
STRING anim_default_attack_str,"attack";
SYNONYM anim_attack_str { TYPE STRING; DEFAULT anim_default_attack_str;}
SYNONYM anim_death_str { TYPE STRING; DEFAULT anim_default_death_str;}

///////////////////////////////////////////////////////////////////////
// Entity skill & flag definitions
// some definitions here are also needed for ACTORS.WDL and WAR.WDL
DEFINE _WALKFRAMES,SKILL1;	// non-zero for old style animation
DEFINE _RUNFRAMES,SKILL2;
DEFINE _ATTACKFRAMES,SKILL3;
DEFINE _DIEFRAMES,SKILL4;

DEFINE _FORCE,SKILL5;		// determines speed
DEFINE _ENTFORCE,SKILL5;
DEFINE _BANKING,SKILL6;		// banking - for player only
DEFINE _PENDOLINO,SKILL6;	// banking - for player only
DEFINE _HITMODE,SKILL6;		// for actors
DEFINE _MOVEMODE,SKILL7;
DEFINE _FIREMODE,SKILL8;	// for actors



DEFINE __FALL,FLAG1;		// take damage from falls

DEFINE __WHEELS,FLAG2;	// block turns without moving
DEFINE __SLOPES,FLAG3;	// adapt the tilt and roll angle to slopes
DEFINE __JUMP,FLAG4;		// be able to jump
DEFINE __BOB,FLAG5;   	// head wave
DEFINE __STRAFE,FLAG6;	// be able to move sidewards
DEFINE __TRIGGER,FLAG7;	// be able to trigger doors automatically

DEFINE __DUCK, FLAG8;	// be able to duck

DEFINE __SOUND,FLAG8;	// internal flag

///////////////////////////////////////////////////////////////////////
DEFINE _HEALTH,SKILL9;
DEFINE _ARMOR,SKILL10;

DEFINE _SPEED,SKILL11;		// speed
DEFINE _SPEED_X,SKILL11;
DEFINE _SPEED_Y,SKILL12;
DEFINE _POWER,SKILL12;		// engine power for aircraft models
DEFINE _SPEED_Z,SKILL13;
DEFINE _ASPEED,SKILL14;		// angular speed
DEFINE _ASPEED_PAN,SKILL14;
DEFINE _ASPEED_TILT,SKILL15;
DEFINE _ASPEED_ROLL,SKILL16;

// for actor entities, and for doors and platforms
DEFINE _TARGET_X,SKILL17;
DEFINE _TARGET_Y,SKILL18;
DEFINE _TARGET_Z,SKILL19;
DEFINE _TARGET_PAN,SKILL20;
DEFINE _TARGET_TILT,SKILL21;
DEFINE _TARGET_ROLL,SKILL22;

// for player entities
DEFINE _FORCE_X,SKILL17;
DEFINE _FORCE_Y,SKILL18;
DEFINE _FORCE_Z,SKILL19;
DEFINE _AFORCE_PAN,SKILL20;
DEFINE _AFORCE_TILT,SKILL21;
DEFINE _AFORCE_ROLL,SKILL22;

DEFINE _WALKSOUND,SKILL23;	// walking sound
DEFINE _SIGNAL,SKILL24;		// communication for actions or client->server
DEFINE _COUNTER,SKILL25;	// internal counter
DEFINE _STATE,SKILL26;		// the state it is in (walk, attack, escape etc.)

DEFINE _WALKDIST,SKILL27;	// distance per walk cycle
DEFINE _RUNDIST,SKILL28;	// distance per run cycle
DEFINE _ANIMDIST,SKILL28;	// time for standing, jumping, and ducking animations
DEFINE _TYPE,SKILL30;		// the type of the entity - door, key, etc.

DEFINE _FALLTIME,SKILL31;	// amount of time spent falling

// Skills up to 32 are reserved for future template actions
// Skills 33-40 can be used freely

///////////////////////////////////////////////////////////////////////
// Mod Date: 7/4/00 DCP
//	 Changed speed -> camera_speed
//          aspeed-> camera_aspeed
var camera_speed[3] = 0,0,0;	// cartesian speed, entity coordinates
var camera_aspeed[3];		// angular speed


var force[3];		// cartesian force, entity coordinates
var absforce[3];	// cartesian force, world coordinates
var aforce[3];		// angular force
var abspeed[3] = 0,0,0;	// cartesian speed, world coordinates
var dist[3];
var absdist[3];	// distances used for MOVE
var p[3];
var friction;
var limit[3];
var covered_dist;
var anim_dist;

var head_angle[3] = 0,0,0;	// separated from other values
var headwave = 0;
var walkwave = 0;
var my_dist;			// distance for actor anim
var player_dist;		// distance for head bobbing
var scan_sector;
var my_height;
var my_height_passable;	// height above passable surface (valid only if on passable surface)
var my_floornormal[3];
var my_floorspeed[3];
var temp_cdist[3] = 120,0,0;   // current camera distance in 3rd p view
//-var debugskill;

// temp values used to replace sonar with trace (DCP-11/9/00)
var vecFrom[3];
var vecTo[3];

var temp2[3];	// another temp var

var	current_fog_index	= 0;	// the current fog color index

SYNONYM player { TYPE ENTITY; }
SYNONYM temp_ent { TYPE ENTITY; }
SYNONYM carry { TYPE ACTION; }
SYNONYM anim_str { TYPE STRING; }

DEFINE _MODE_WALKING,1;
DEFINE _MODE_DRIVING,2;
DEFINE _MODE_SWIMMING,3;
DEFINE _MODE_DIVING,4;
DEFINE _MODE_WADING,5;
DEFINE _MODE_HELICOPTER,6;	// very primitive helicopter mode
DEFINE _MODE_ROCKETEER,7;
DEFINE _MODE_DUCKING,8;		// ducking
DEFINE _MODE_JUMPING,9;		// jumping
DEFINE _MODE_CRAWLING,10;	// crawling
DEFINE _MODE_STILL,15;

DEFINE _MODE_PLANE,16;
DEFINE _MODE_CHOPPER,17;


// modes 20 and above are handled by a different wdl
DEFINE _MODE_ATTACK,20;

DEFINE _SOUND_WALKER,1;
DEFINE _SOUND_ROBOT,2;

DEFINE _TYPE_PLAYER,1;
DEFINE _TYPE_ACTOR,2;
DEFINE _TYPE_FOE,3;
DEFINE _TYPE_DOOR,10;
DEFINE _TYPE_GATE,11;
DEFINE _TYPE_ELEVATOR,12;
DEFINE _TYPE_GUN,20;
DEFINE _TYPE_AMMO,21;
DEFINE _TYPE_ARMOR,22;
DEFINE _TYPE_HEALTH,23;

DEFINE _FOG_UNDERWATER,2;	// fog color 2 is used for underwater fog

///////////////////////////////////////////////////////////////////////
//-DEFINE RETURN,END;	// I prefer RETURN to END

SOUND beep_sound,<beep.wav>;
//SYNONYM debugsyn { TYPE ENTITY; }

///////////////////////////////////////////////////////////////////////


// Desc: player drive action
//
// Mod Date: 8/31/00 DCP
//		Scale the player by vec_scale
ACTION player_drive
{
	MY._MOVEMODE = _MODE_DRIVING;
	MY._FORCE = 1.5;
	MY._BANKING = 0.5;
	MY.__SLOPES = ON;
	MY.__TRIGGER = ON;

	player_move();
}

// Desc: player walk action
//
// Mod Date: 8/31/00 DCP
//		Scale the player by vec_scale
ACTION player_walk
{
	MY._MOVEMODE = _MODE_WALKING;
	MY._FORCE = 0.75;
	MY._BANKING = -0.1;
	MY.__JUMP = ON;
	MY.__DUCK = ON;
	MY.__STRAFE = ON;
	MY.__BOB = ON;
	MY.__TRIGGER = ON;

	player_move();
}

// Desc: player swim action
//
ACTION player_swim
{
	MY._MOVEMODE = _MODE_SWIMMING;
	MY._FORCE = 0.75;
	MY._BANKING = 0;
	MY.__JUMP = ON;
	MY.__DUCK = ON;
	MY.__STRAFE = OFF;
	MY.__BOB = ON;

	player_move();
}

///////////////////////////////////////////////////////////////////////
// Desc: Shakes the player, used for hits and death
function player_shake()
{
	if(random(1) > 0.5)
	{
		MY.ROLL += 8;
		MY.TILT += 8;
		waitt(2);
		MY.TILT -= 5;
		waitt(2);
		MY.ROLL -= 8;
		MY.TILT -= 3;
	}
	else
	{
		MY.ROLL -= 8;
		MY.TILT += 8;
		waitt(2);
		MY.TILT -= 5;
		waitt(2);
		MY.ROLL += 8;
		MY.TILT -= 3;
	}
}

// Desc: player tips over, can be used for death
function player_tip()
{
	MY._MOVEMODE = 0;	// suspend normal movement action
	eye_height_up.Z = eye_height_up;	// store original eye height
	while(MY.ROLL < 80)
	{
		MY.ROLL += 8 * TIME;
		MY.TILT += 2 * TIME;
		if(eye_height_up > 0.15)
		{
			eye_height_up -= 0.1 * TIME;
		}

		if(client_moving==0) { move_view(); }
		wait(1);
	}

	MY.ROLL = 80;
	MY.TILT = 20;
	eye_height_up = eye_height_up.Z;	// restore original eye height
}



////////////////////////////////////////////////////////////////////////
// Desc: main player movement action
//			called from 'player_walk', 'player_drive', & 'player_swim'
//
// Mod Date: 5/10/00 @ 973 Doug Poston
//           Added code to handle swimming
// Mod Date: 5/11/00 @ 097 Doug Poston
//           Added code to handle ducking and crawling
// Mod Date: 5/16/00  Doug Poston
//				 Modified underwater fog code
//				 Modified player MIN_Z (when getting in & out of water)
//				 Fixed so you can no longer crawl over water
// Mod Date: 5/16/00 Doug Poston
//				 Returned fog control back to the camera views
// Mod Date: 5/18/00 Doug Poston
//				 Removed MIN_Z modifications (too easy to get stuck in objects)
// Mod Date: 5/25/00 Doug Poston
//				 Using an 'offset sonar' (7 units) while swimming to check if
//				the player is ON_PASSABLE
// Mod Date: 5/29/00 Doug Poston
//				 Change 'offset sonar' from 7 to 16 units
// Mod Date: 6/5/00 Doug Poston
//				 Removed Sets
// Mod Date: 6/27/00 Doug Poston
//				 Replaced ACCEL
// Mod Date: 6/29/00 Doug Poston
//				Remove IN_PASSABLE check for wading (fixed in v4.193)
// Mod Date: 10/31/00 Doug Poston
//				Replaced min with max in ASPEED (to eliminate 'creep')
// Mod Date: 11/1/00 DCP
//				Replace SHOOT with trace() and VECROTATE with vec_rotate
// Mod Date: 11/10/00 DCP
//				Edited code dealing with swimming (collision info has changed)
// Mod Date: 02/09/01 DCP
//				If entering passable block stop falling (MY._SPEED_Z = 0)
// Mod Date: 02/11/01 DCP
//				Use "my_height_passable" for passable blocks (fixed wading)
ACTION player_move
{
	if(MY.CLIENT == 0) { player = ME; } // created on the server?

	MY._TYPE = _TYPE_PLAYER;
	MY.ENABLE_SCAN = ON;	// so that enemies can detect me
	if((MY.TRIGGER_RANGE == 0) && (MY.__TRIGGER == ON)) { MY.TRIGGER_RANGE = 32; }

	if(MY._FORCE == 0) {  MY._FORCE = 1.5; }
	if(MY._MOVEMODE == 0) { MY._MOVEMODE = _MODE_WALKING; }
	if(MY._WALKFRAMES == 0) { MY._WALKFRAMES = DEFAULT_WALK; }
	if(MY._RUNFRAMES == 0) { MY._RUNFRAMES = DEFAULT_RUN; }
	if(MY._WALKSOUND == 0) { MY._WALKSOUND = _SOUND_WALKER; }

	anim_init();      // init old style animation
	perform_handle();	// react on pressing the handle key


	// while we are in a valid movemode
	while((MY._MOVEMODE > 0)&&(MY._MOVEMODE <= _MODE_STILL))
	{
		// if we are not in 'still' mode
		if(MY._MOVEMODE != _MODE_STILL)
		{
			// Get the angular and translation forces (set aforce & force values)
			_player_force();

			// find ground below (set my_height, my_floornormal, & my_floorspeed)
			scan_floor();

			// if they are on or in a passable block...
			if( ((ON_PASSABLE != 0) && (my_height_passable < -MY.MIN_Z + 5)) || (IN_PASSABLE != 0) )
			{

				// if not already swimming or wading...
				if((MY._MOVEMODE != _MODE_SWIMMING) && (MY._MOVEMODE != _MODE_WADING))
				{
  					play_sound(splash,50);
  					MY._MOVEMODE = _MODE_SWIMMING;

					// stay on/near surface of water
					MY._SPEED_Z = 0;
  				}

				// if swimming...
  				if(MY._MOVEMODE == _MODE_SWIMMING) // swimming on/in a passable block
				{
					if(ON_PASSABLE == ON) // && (IN_PASSABLE != ON)) -> Not need with version 4.193+
					{
						// check for wading
						temp.X = MY.X;
    					temp.Y = MY.Y;
    		  			temp.Z = MY.Z + MY.MIN_Z;	// can my feet touch?
						trace_mode = IGNORE_ME + IGNORE_PASSABLE + IGNORE_PASSENTS;
						trace(MY.POS,temp);

						if(RESULT > 0)
						{
							// switch to wading
							MY._MOVEMODE = _MODE_WADING;
 				 			MY.TILT = 0;       // stop tilting
							my_height = RESULT + MY.MIN_Z;	// calculate wading height
						}

 					}

				}// END swimming on/in a passable block

				// if wading...
 				if(MY._MOVEMODE == _MODE_WADING) // wading on/in a passable block
				{
  					// check for swimming
					temp.X = MY.X;
    					temp.Y = MY.Y;
    					temp.Z = MY.Z + MY.MIN_Z;	// can my feet touch?

    				//SHOOT MY.POS,temp;  // NOTE: ignore passable blocks
					trace_mode = IGNORE_ME + IGNORE_PASSABLE + IGNORE_PASSENTS;
					trace(MY.POS,temp);
					if(RESULT == 0)
					{
						// switch to swimming
						MY._MOVEMODE = _MODE_SWIMMING;
					}
					else	// use SOLID surface for height (can't walk on water)
					{
	 					my_height = RESULT + MY.MIN_Z;    // calculate wading height
 					}
				} // END wading on/in a passable block
	 		} // END if they are on or in a passable block...
			else  // not in or on a passable block
			{
				// if wading or swimming while *not* on/in a passable block...
				if((MY._MOVEMODE == _MODE_SWIMMING) || (MY._MOVEMODE == _MODE_WADING))
				{
					// get out of the water (go to walk mode)
					MY._MOVEMODE = _MODE_WALKING;
					MY.TILT = 0;       // stop tilting
				}
 			} // END not in or above water


  			// if he is on a slope, change his angles, and maybe let him slide down
			if(MY.__SLOPES == ON)
			{
				// Adapt the player angle to the floor slope
				MY_ANGLE.TILT = 0;
				MY_ANGLE.ROLL = 0;
				if((my_height < 10) && ((my_floornormal.X != 0) || (my_floornormal.Y != 0) ))
				{	// on a slope?
					// rotate the floor normal relative to the player
					MY_ANGLE.PAN = -MY.PAN;
					vec_rotate(my_floornormal,MY_ANGLE);
					// calculate the destination tilt and roll angles
					MY_ANGLE.TILT = -ASIN(my_floornormal.X);
					MY_ANGLE.ROLL = -ASIN(my_floornormal.Y);
				}
				// change the player angles towards the destination angles
				MY.TILT += 0.2 * ANG(MY_ANGLE.TILT-MY.TILT);
				MY.ROLL += 0.2 * ANG(MY_ANGLE.ROLL-MY.ROLL);
			}
			else
			{
				// If the ROLL angle was not equal to zero,
				// apply a ROLL force to set the angle back
				//jcl 07-08-00 fix loopings on < 3 fps systems
				MY.ROLL -= 0.2*ANG(MY.ROLL);
			}

			// Now accelerate the angular speed, and change his angles
			// -old method- ACCEL	MY._ASPEED,aforce,ang_fric;
			temp = max(1-TIME*ang_fric,0);     // replaced min with max (to eliminate 'creep')
			MY._ASPEED_PAN  = (TIME * aforce.pan)  + (temp * MY._ASPEED_PAN);    // vp = ap * dt + max(1-(af*dt),0)  * vp
			MY._ASPEED_TILT = (TIME * aforce.tilt) + (temp * MY._ASPEED_TILT);
			MY._ASPEED_ROLL = (TIME * aforce.roll) + (temp * MY._ASPEED_ROLL);

  			temp = MY._ASPEED_PAN * MY._SPEED_X * 0.05;
			if(MY.__WHEELS)
			{	// Turn only if moving ahead
				//jcl 07-03-00 patch to fix movement
				MY.PAN += temp * TIME;
			}
			else
			{
				MY.PAN += MY._ASPEED_PAN * TIME;
			}
			MY.ROLL += (temp * MY._BANKING + MY._ASPEED_ROLL) * TIME;

			// the head angle is only set on the player in a single player system.
			if (ME == player)
			{
				head_angle.TILT += MY._ASPEED_TILT * TIME;
				//jcl 07-03-00 end of patcht

				// Limit the TILT value
				head_angle.TILT = ang(head_angle.TILT);
				if(head_angle.TILT > 80) { head_angle.TILT = 80; }
				if(head_angle.TILT < -80) { head_angle.TILT = -80; }
			}

			// disable strafing
			if(MY.__STRAFE == OFF)
			{
				force.Y = 0;	// no strafe
			}


			// if swimming...
			if(MY._MOVEMODE == _MODE_SWIMMING)
			{
 				// move in water
  				swim_gravity();
			}
			else // not swimming
			{
				// if wading...
				if(MY._MOVEMODE == _MODE_WADING)
				{
					wade_gravity();
				}
				else // not swimming or wading (not in water)
				{
					// Ducking or crawling...
					if((MY._MOVEMODE == _MODE_DUCKING) || (MY._MOVEMODE == _MODE_CRAWLING))
					{
						if(force.Z >= 0)
						{
							MY._MOVEMODE = _MODE_WALKING;
						}
						else	// still ducking
						{
							// reduce height by ducking value
							my_height += duck_height;
						}

					}
					else  // not ducking or crawling
					{
						// if we have a ducking force and are not already ducking or crawling...
						if((force.Z < 0) && (MY.__DUCK == ON))		// dcp 7/28/00 added __DUCK
						{
							// ...switch to ducking mode
							MY._MOVEMODE = _MODE_DUCKING;
							MY._ANIMDIST = 0;
							force.Z = 0;
						}
					}

					// Decide whether the actor can jump or not. He can't if he is in the air
					if((jump_height <= 0)
						|| (MY.__JUMP == OFF)
						|| (my_height > 4)
						|| (force.Z <= 0))
					{
						force.Z = 0;
					}

					// move on land
					move_gravity();
				}  // END (not in water)
			}// END not swimming
		} // END not in 'still' mode

		// animate the actor
		actor_anim();

		// If I'm the only player, draw the camera and weapon with ME
		if(client_moving == 0) { move_view(); }

		carry();		// action synonym used to carry items with the player (eg. a gun or sword)

		// Wait one tick, then repeat
		wait(1);
	}  // END while((MY._MOVEMODE > 0)&&(MY._MOVEMODE <= _MODE_STILL))
}



// Desc: This is the main movement action for the camera
//
// Mod Date: 6/27/00 Doug Poston
//				Replaced ACCEL (x2)
// Mod Date: 7/3/00 Doug Poston
//				Added time correction to CAMERA.PAN,.TILT, & .ROLL
// Mod Date: 7/4/00 DCP
//				Switched generic speed and aspeed to camera_speed and camera_aspeed
//				Movement is now time corrected
// Mod Date: 11/8/00 DCP
//				Replace move_view with a simple vec_add()
ACTION camera_move
{
	_camera = 1;
	while(_camera == 1)
	{
		_player_intentions();     // set force and aforce value from user input

 		// -old method- ACCEL	aspeed,aforce,0.9;
		camera_aspeed.pan  += (TIME * aforce.pan)  - (0.9 * camera_aspeed.pan);
		camera_aspeed.tilt += (TIME * aforce.tilt) - (0.9 * camera_aspeed.tilt);
		camera_aspeed.roll += (TIME * aforce.roll) - (0.9 * camera_aspeed.roll);

		CAMERA.PAN += camera_aspeed.PAN * TIME;
		CAMERA.TILT += camera_aspeed.TILT * TIME;
		CAMERA.ROLL += camera_aspeed.ROLL * TIME;

		// Calculate camera's new speed
 		// -old method- ACCEL	speed,force,0.9;
		camera_speed.x += (TIME * force.x) - (0.9 * camera_speed.x);
		camera_speed.y += (TIME * force.y) - (0.9 * camera_speed.y);
		camera_speed.z += (TIME * force.z) - (0.9 * camera_speed.z);

		// calculate relative distance
   	dist.x = camera_speed.x * TIME;
 	 	dist.y = camera_speed.y * TIME;
 	 	dist.z = camera_speed.z * TIME;

		// Replace move_view with XYZ displacement
		//move_view CAMERA,dist,NULLSKILL;
		vec_rotate(dist.x,CAMERA.pan);
		vec_add(CAMERA.X, dist.X);

		wait(1);
	}
}

/////////////////////////////////////////////////////////////////////
// Core part of move action, common for actors and players
function move_airborne()
{
	MY._POWER += 0.1*force.Z;
	if(MY._POWER < 0) { MY._POWER = 0; }
	if(MY._POWER > power_max) { MY._POWER = power_max; }
	absforce.X = 0;
	absforce.Y = 0;
	absforce.Z = 0;

	friction = air_fric;
	force.X = 0;
	force.Y = 0;
	force.Z = 0;
}

function anim_airborne()
{
	// standing animation
	if(MY._POWER > 0)	// engine running
	{
		MY._ANIMDIST += TIME * MY._POWER;
		// wrap animation time to a value between zero and anim_stand_ticks
		if(MY._ANIMDIST > anim_stand_ticks)
		{
			MY._ANIMDIST -= anim_stand_ticks;
		}
		// calculate a percentage out of the animation time
		temp =  100 * MY._ANIMDIST / anim_stand_ticks;
		// set the frame from the percentage
		ent_cycle(anim_stand_str,temp);
		return;
	}
	return;
}


////////////////////////////////////////////////////////////////////////
// Desc: gravity / buoyancy effect on the player in water (IN_PASSABLE)
//       this action should be called when the player is swimming (_MODE_SWIMMING)
//
// Created: 05/9/00 @ 863 by Doug Poston
//
// Mod Date: 5/10/00 @ 913 by Doug Poston
//				Added code to TILT the player (allowing them to dive and rise in water)
// Mod Date: 5/18/00 by Doug Poston
//				Added code to drop player to the surface of the water
// Mod Data: 5/24/00 Doug Poston
//				 Using an 'offset sonar' (7 units) to check if the player is ON_PASSABLE
// Mod Date: 5/29/00 Doug Poston
//				 Change 'offset sonar' from 7 to 16 units
// Mod Date: 6/19/00 Doug Poston
//				 Reset _FALLTIME (no falling damage is you land in water)
// Mod Date: 6/27/00 Doug Poston
//				Replaced ACCEL
// Mod Date: 6/28/00 Doug Poston
//				Modified gravity check to handle ON_PASSABLE while IN_PASSABLE
// Mod Date: 6/29/00 Doug Poston
//				Remove IN_PASSABLE check while ON_PASSABLE (6/28/00 mod) (fixed in v4.193)
// Mod Date: 7/3/00 Doug Poston
//				Fixed code so forces are now completely TIME dependent
// Mod Date: 7/22/00 JCL
//				Modified because of changes in scan_floor
// Mod Date: 8/31/00 DCP
//				Scale dist and absdist by movement_scale before MOVE
// Mod Date: 11/9/00 DCP
//				Change diving (player no longer rotates)
// Mod Date: 01/16/01 JCL
//				Removed absdist movement_scale because absdist is calculated from external forces
// Mod Date: 02/08/01 DCP
//				Changes to "scan_floor"  remove need to offset for hull
// Mod Date: 02/09/01 DCP
//				Added code to 'surface' section that allows the player to 'hop' out of the water.
// Mod Date: 02/11/01 DCP
//				Use "my_height_passable" in place of "my_height"
function swim_gravity()
{
	friction = water_fric;     // set friction to water friction

	MY._FALLTIME = 0;	// no falling damage in water

	// force.Z is used for diving/surfacing
	if(force.Z == 0)
	{
		// level out player
		if(MY.TILT < 0)
		{
			MY.TILT += 3 * TIME;
			if(MY.TILT > 0)
			{
				MY.TILT = 0;
			}
		}
		else
		{
			if(MY.TILT > 0)
			{
				MY.TILT -= 3 * TIME;
				if(MY.TILT < 0)
				{
					MY.TILT = 0;
				}
 			}
		}
	}
	else
	{
		// surface player
		if(force.Z > 0)
		{
			MY.TILT += 3 * TIME;
			if(MY.TILT > 30)
			{
				MY.TILT = 30;
			}
		}
  		else
		{
			// player diving
			MY.TILT -= 3 * TIME;
			if(MY.TILT < -30)
			{
				MY.TILT = -30;
			}
		}
	}

/*	NO absforce needed in this swim_gravity
	// reset absolute forces
  	absforce.X = 0;
	absforce.Y = 0;
	absforce.Z = 0;
*/
	// Swimming - rhythmic acceleration
	force.X *= 0.5 + (0.25*walkwave);
	force.Y *= 0.5;
	force.Z *= 0.025;   // surface/diving force


	// accelerate the entity relative speed by the force
	// replaced min with max (to eliminate 'creep')
	temp = max((1-TIME*friction),0);
	MY._SPEED_X = (TIME * force.x) + (temp * MY._SPEED_X);    // vx = ax*dt - min(f*dt,1) * vx
	MY._SPEED_Y = (TIME * force.y) + (temp * MY._SPEED_Y);    // vy = ay*dt - min(f*dt,1) * vy
	MY._SPEED_Z = (TIME * force.z) + (temp * MY._SPEED_Z);    // vz = az*dt - min(f*dt,1) * vz


	// calculate relative distances
	dist.x = MY._SPEED_X * TIME; 		// dx = vx * dt
	dist.y = MY._SPEED_Y * TIME;     // dy = vy * dt
	dist.z = MY._SPEED_Z * TIME;     // dz = vz * dt


//jcl 07-22-00  scan_floor changed
	if((on_passable_ == ON) )//&& (my_height > MY.MIN_Z))//??MY.MIN_Z)) //&&  (IN_PASSABLE ==0)) -> check not need in v4.193+
	{
		// reset absolute distance
		absdist.x = 0;
		absdist.y = 0;
		absdist.z = 0;

		// if MY center (use passable height) is greater than the surface level...
		if(((my_height_passable) > 5))// (MY.MIN_Z + 21)))   // 21 = 16 "hull" + 5 "float value"
		{
			 // pull down to the surface of the water
  			absdist.Z -= min(gravity,my_height_passable);
		}


		// restrict climbing rotation on surface and check for edge...
		if(MY.TILT > 5)
		{
			MY.TILT = 5;   // shallow climb


			// If the user is near a solid edge and trying to swim up try to hop out
			// scan ahead of ME
			vec_set(vecFrom,MY.X);
			vecFrom.X += (MY.MAX_X + 25) * cos(MY.PAN);
			vecFrom.Y += (MY.MAX_X + 25) * sin(MY.PAN);
			vec_set(vecTo,vecFrom);
			vecFrom.Z += MY.MAX_Z;		// adjust this to adjust height

			trace_mode = IGNORE_ME + IGNORE_SPRITES + IGNORE_PASSENTS + IGNORE_MODELS + IGNORE_PASSABLE;
			if( (trace(vecFrom,vecTo)) != 0)
			{
				// hop out of water
				temp.X = 0; temp.Y = 0; temp.Z = MY.MAX_Z;
				move(ME,temp,NULLSKILL);// up
				temp.X = MY.MAX_X; temp.Z = 0;
				move(ME,temp,NULLSKILL);// over

			}
		}

		// Now move ME by the relative and the absolute speed
		YOU = NULL;	// YOU entity is considered passable by MOVE
		vec_scale(dist,movement_scale);	// scale distance by movement_scale
		//	Removed absdist movement_scale because absdist is calculated from external forces
		//---vec_scale(absdist,movement_scale);	// scale absolute distance by movement_scale
		move(ME,dist,absdist);
	}
	else   // underwater
	{
 		// NOTE: this is where we would add buoyancy (using absforce)
		// right now we are assuming zero buoyancy

		// NOTE: this is where we could add the effect of currents (using absforce)

		// Now move ME by the relative and the absolute speed
		YOU = NULL;	// YOU entity is considered passable by MOVE
		vec_scale(dist,movement_scale);	// scale distance by movement_scale
		move(ME,dist,NULLSKILL);
	}



	// Store the distance covered, for animation
	my_dist = RESULT;
	// Store the distance for player 1st person head bobbing
	// (only for single player system)
	if(ME == player)
	{
		player_dist += MY._SPEED_X;//SQRT(speed.X*speed.X + speed.Y*speed.Y);
	}
}


// Desc: wading movement action
//       this action should be called when the player is wading (_MODE_WADING)
//
// Mod Date: 5/18/00 by Doug Poston
//				Created
// Mod Date: 5/25/00 by Doug Poston
//				Adjusted ground elasticity (so it doesn't force player to swim)
// Mod Date: 5/25/00 by Doug Poston
//				Adjust player force by water depth (slower the deeper the player is wading)
// Mod Date: 5/29/00 Doug Poston
//				 Change 'offset sonar' from 7 to 16 units
// Mod Date: 6/19/00 Doug Poston
//				 Reset _FALLTIME (no falling damage is you land in water)
// Mod Date: 6/27/00 Doug Poston
//				Replaced ACCEL (x2)
// Mod Date: 7/3/00 Doug Poston
//				Fixed code so speed and distance are TIME dependent
// Mod Date: 8/31/00 DCP
//				Scaled dist and absdist by movement_scale before MOVE command
// Mod Date: 01/16/01 JCL
//				Removed absdist movement_scale because absdist is calculated from external forces
function wade_gravity()
{
	// basic friction
	friction = gnd_fric;

	MY._FALLTIME = 0;	// reset falltime (no falling damage in water)

	//adjust player force depending on depth of water
//	MY.Z += 16;
//	SONAR	MY,4000;
//	MY.Z -= 16;
//jcl 07-22-00  scan_floor changed
	temp = 1.0 - (my_height / min(-1,MY.MIN_Z));	// MY.min_z can be 0!!
	if(temp < 0.1)	// minimum speed
	{
		temp = 0.1;
	}
	force.X *= temp;
	force.Y *= temp;
	force.Z *= temp;


	// reset absforce
	absforce.X = 0;
	absforce.Y = 0;
	absforce.Z = 0;

	// If on a slope, apply gravity to draw him downwards:
	if(my_floornormal.Z < 0.9)
	{
		// reduce ahead force because player force it is now deflected upwards
		force.x *= my_floornormal.z;
		force.y *= my_floornormal.z;
		// gravity draws him down the slope (but only at 1/4 of above water)
		absforce.X = my_floornormal.x * gravity * slopefac * 0.25;
		absforce.Y = my_floornormal.y * gravity * slopefac * 0.25;
	}

	// -old method- ACCEL	speed,force,friction;
 	// replaced min with max (to eliminate 'creep')
	temp = max((1-TIME*friction),0);
	MY._SPEED_X = (TIME * force.x) + (temp * MY._SPEED_X);    // vx = ax*dt + max(1-f*dt,0) * vx
	MY._SPEED_Y = (TIME * force.y) + (temp * MY._SPEED_Y);    // vy = ay*dt + max(1-f*dt,0) * vy
	MY._SPEED_Z = (TIME * absforce.z) + (temp * MY._SPEED_Z);


	// calculate relative distances
	dist.x = MY._SPEED_X * TIME; 		// dx = vx * dt
	dist.y = MY._SPEED_Y * TIME;     // dy = vy * dt
	dist.z = 0;                      // dz = 0

	// calculate absolute distances
	absdist.x = absforce.x * TIME * TIME; 		// dx = ax * dt^2
	absdist.y = absforce.y * TIME * TIME;     // dy = ay * dt^2
	absdist.z = 0; // NO JUMPING WHILE WADING

 	// Add the speed given by the ground elasticity
 	if(my_height < -5)
	{
		temp = my_height;
		if(temp < -10)  { temp = -10; }
 		absdist.Z -= (temp - 5);
	}

	// Pull back down to the underwater surface
	// NOTE: this is taken care of by the player switching to swimming, then back to wading

	// Now move ME by the relative and the absolute speed
	YOU = NULL;	// YOU entity is considered passable by MOVE
	vec_scale(dist,movement_scale);	// scale distance by movement_scale
	//--vec_scale(absdist,movement_scale);	// scale absolute distance by movement_scale
	move(ME,dist,absdist);

	// Store the distance covered, for animation
	my_dist = RESULT;
	// Store the distance for player 1st person head bobbing
	// (only for single player system)
	if(ME == player)
	{
		player_dist = my_dist;
	}
}


// Desc: calculate the damage taken by a fall
//
//	Param: fall_time and MY must be set before calling
//
// Note: override this function if you want to use a different formula
function	fall_damage()
{
	// calculate damage depending on _FALLTIME
 	return(10 + INT((MY._FALLTIME - fall_time) * 1.75));
}

// Desc: on ground movement action
//			use when player is not swimming or wading
//
// Mod Date: 5/10/00 @ 942 by Doug Poston
//				Added code to switch to jumping mode when needed
// Mod Date: 5/25/00 by Doug Poston
//				Split MOVE into two, so my_dist is now a function of player
//			  movement only (ie. not effected by elevators or platforms)
// Mod Date: 6/19/00 by Doug Poston
//          Added falling damage.
//				_FALLTIME keeps track of the time spent falling
//				if __FALL is set, damage is taken when landing
// Mod Date: 6/27/00 Doug Poston
//				Replace ACCEL (x2)
// Mod Date: 7/3/00 JCL
//				quick patch to fix movement for Adeptus
// Mod Date: 7/3/00 DCP
//				Modified code so speed and distance are TIME dependent
// Mod Date: 7/18/00 DCP
//				Removed time dependence on forces
//				Changed slope gravity
// Mod Date: 7/19/00 DCP
//				Changed jumping code so player always jumps to the same height
// Mod Date: 8/10/00 JCL
//				Changed 'airborne' force values to prevent entities from 'sticking'
// Mod Date: 8/10/00 JCL
//      		"bring to ground level - only if slope not too steep"
// Mod Date: 8/10/00 DCP
//				Replace fall damge formula with call to 'fall_damage'
// Mod Date: 8/31/00 DCP
//				Scale dist and absdist by movement_scale before MOVE command
// Mod Date: 11/9/00 DCP
// 			Replaced the double MOVE with a single MOVE and a distance check
// Mod Date: 01/16/01 JCL
//				Removed absdist movement_scale because absdist is calculated from external forces
//				Apply movement_scale to jumping force only
function move_gravity()
{
	// Filter the forces and frictions dependent on the state of the actor,
	// and then apply them, and move him

	// First, decide whether the actor is standing on the floor or not
	if(my_height < 5)
	{

		// Calculate falling damage
 		if((MY.__FALL == ON) && (MY._FALLTIME > fall_time))
  		{
			MY._HEALTH -= fall_damage();		// take damage depending on fall_time
 		}
		MY._FALLTIME = 0; 	// reset falltime

		friction = gnd_fric;
		if(MY._MOVEMODE == _MODE_DRIVING)
		{
			// Driving - less friction, less force
			friction *= 0.3;
			force.X *= 0.3;
		}

		// reset absolute forces
		absforce.X = 0;
		absforce.Y = 0;
		absforce.Z = 0;

		// If on a slope, apply gravity to draw him downwards:
		if(my_floornormal.Z < 0.9)
		{
			// reduce ahead force because player force it is now deflected upwards
			force.x *= my_floornormal.z;
			force.y *= my_floornormal.z;
			// gravity draws him down the slope
			absforce.X = my_floornormal.x * gravity * slopefac;
			absforce.Y = my_floornormal.y * gravity * slopefac;
		}
	}
	else	// (my_height >= 5)
	{
		// airborne - reduce all relative forces
		// to prevent him from jumping or further moving in the air
		friction = air_fric;
		//jcl 10-08-00
		force.X *= 0.2; // don't set the force completely to zero, otherwise
		force.Y *= 0.2; // player could be stuck on top of a non-wmb entity
		force.Z = 0;

		absforce.X = 0;
		absforce.Y = 0;
		// Add the world gravity force
		absforce.Z = -gravity;

		// only falling if moving downward
		if(MY._SPEED_Z <= 0)
		{
			MY._FALLTIME += TIME;   // add falling time
		}
	}

	// accelerate the entity relative speed by the force
	// -old method- ACCEL	speed,force,friction;
 	// replaced min with max (to eliminate 'creep')
	temp = max((1-TIME*friction),0);
	MY._SPEED_X = (TIME * force.x) + (temp * MY._SPEED_X);    // vx = ax*dt + max(1-f*dt,0) * vx
	MY._SPEED_Y = (TIME * force.y) + (temp * MY._SPEED_Y);    // vy = ay*dt + max(1-f*dt,0) * vy
	MY._SPEED_Z = (TIME * absforce.z) + (temp * MY._SPEED_Z);

	// calculate relative distances to move
	dist.x = MY._SPEED_X * TIME;  	// dx = vx * dt
	dist.y = MY._SPEED_Y * TIME;     // dy = vy * dt
	dist.z = 0;                      // dz = 0  (only gravity and jumping)

	// calculate absolute distance to move
	absdist.x = absforce.x * TIME * TIME;   // dx = ax*dt^2
	absdist.y = absforce.y * TIME * TIME;   // dy = ay*dt^2
	absdist.z = MY._SPEED_Z * TIME;         // dz = vz*dt

//jcl 07-22-00
	// Add the speed given by the ground elasticity and the jumping force
	if(my_height < 5)
	{
		// bring to ground level - only if slope not too steep
		//jcl 10-08-00
  		if(my_floornormal.Z > slopefac/4)
		{
			absdist.z = -max(my_height,-10);
		}

		// if we have a jumping force...
		if(force.Z > 0)
		{
			// predict the initial speed required to reach the jump height
			// v = a*t; s = a/2*t*t; -> v = sqrt(2*a*s)
			MY._SPEED_Z = sqrt((jump_height-my_height)*2*gravity);
			// scale distance from jump (absdist.z) by movement_scale
			absdist.z = MY._SPEED_Z * TIME * movement_scale;

			// ...switch to jumping mode
			MY._MOVEMODE = _MODE_JUMPING;
			MY._ANIMDIST = 0;
		}

		// If the actor is standing on a moving platform, add it's horizontal displacement
		absdist.X += my_floorspeed.X;
		absdist.Y += my_floorspeed.Y;
	}


	// Restrict the vertical distance to the maximum jumping height
	// (scale jump_height by movement_scale)
	if((MY.__JUMP == ON) && (absdist.z > 0) && (absdist.z + my_height > (jump_height * movement_scale)))
	{
		absdist.z = max((jump_height * movement_scale)- my_height,0);
	}

	// Now move ME by the relative and the absolute speed
	YOU = NULL;	// YOU entity is considered passable by MOVE

	vec_scale(dist,movement_scale);	// scale distance by movement_scale
	// jcl: removed absdist scaling because absdist is calculated from external forces
	//--- vec_scale(absdist,movement_scale);	// scale absolute distance by movement_scale


	// Replaced the double MOVE with a single MOVE and a distance check
//-old-	move(ME,dist,NULLVECTOR);
// Store the distance covered, for animation
//-old-	my_dist = RESULT;
//-	move(ME,NULLVECTOR,absdist);
 	move(ME,dist,absdist);
	if(RESULT > 0)
	{
		// only use the relative distance traveled (for animation)
		my_dist = vec_length(dist);
	}
	else
	{
		// player is not moving, do not animate
		my_dist = 0;
	}


	// Store the distance for player 1st person head bobbing
	// (only for single player system)
	if(ME == player)
	{
		player_dist += SQRT(dist.X*dist.X + dist.Y*dist.Y);
	}
//jcl 07-03-00 end of patch
}

// Desc: set up for animation
// 		scale entity by actor_scale
//			if using the "old style animation"
//	      	- split the integer and fractional parts of the animation
//				  frame numbers, and store distance factors
//
// Mod Date: 8/31/00 DCP
//		Scale the player by vec_scale
function anim_init()
{
	vec_scale(MY.SCALE_X,actor_scale);

	temp = frc(MY._WALKFRAMES) * 1000;
	if(temp != 0)
	{ // old style animation
		MY._WALKFRAMES = int(MY._WALKFRAMES);
		if(MY._WALKFRAMES == 0) { MY._WALKFRAMES = 13; }
		MY._WALKDIST = MY._WALKFRAMES / temp;

		temp = frc(MY._RUNFRAMES) * 1000;
		MY._RUNFRAMES = int(MY._RUNFRAMES);
		if(MY._RUNFRAMES == 0) { MY._RUNFRAMES = 5; }
		MY._RUNDIST = MY._RUNFRAMES / temp;
	}
}

// Desc: play some kinds of foot sound
//
// Mod Date: 6/9/00 Doug Poston
//				changed to function
function _play_walksound()
{
	if((ME == player) && (person_3rd == 0)) { return; }	// don't play entity sounds for 1st person player
	if(MY._WALKSOUND == _SOUND_WALKER) { play_entsound(ME,thud,60); }
	if(MY._WALKSOUND == _SOUND_ROBOT) { play_entsound(ME,robo_thud,60); }
}

////////////////////////////////////////////////////////////////////
// Desc: Main action to animate a walking actor, depending on dist
//		  covered (my_dist)
//
// Mod Date: 5/9/00 @ 812 Doug Poston
//				Added swimming animation
// Mod Date: 5/10/00 @ 970 Doug Poston
//				Added jumping animation
// Mod Date: 5/11/00 @ 795 by Doug Poston
//				Added ducking and crawling animations
// Mod Date: 5/23/00 Doug Poston
// 			Added code to check for backwards motion (using force.X)
// Mod Date: 6/23/00 Doug Poston
// 			Added code for attack animations
// Mod Date: 6/27/00 Doug Poston
//				Modified attack animation code to only work for player animation
// Mod Date: 8/31/00 DCP
//				Modified walk_or_run var by movement_scale
// Mod Date: 11/8/00 DCP
//          Replaced set_frame with ent_frame
//          Replaced set_cycle with ent_cycle
function actor_anim()
{
	// decide whether it's a frame number (old) or frame name (new) animation
	if(frc(MY._WALKFRAMES) > 0) { goto(old_style_anim); }

	// START NEW STYLE ANIMATIONS (frame names)

	// Check to see if player is attacking
	if(( ME == PLAYER) && (MY._FIREMODE != 0))
	{
		// if you have more than one attacking animation, here's where you would test for it...

		// calculate a percentage out of the animation time
		temp =  100 * MY._ANIMDIST / anim_attack_ticks;
		// set the frame from the percentage
		// -old- set_frame ME,anim_attack_str,temp;
		ent_frame(anim_attack_str,temp);

		// increment _ANIMDIST by elapsed time
		MY._ANIMDIST += TIME;
		// check to see if we finished the attack animation
		if(MY._ANIMDIST > anim_attack_ticks)
		{
			MY._ANIMDIST = 0; // reset animation distance
			MY._FIREMODE = 0;	// reset firemode
		}
		return;
	}
	else // not firing
	{
		/////////////////////////////////////////////////////////////////////
		// Animations that can take place standing still (jumping, ducking, etc.)
		/////////////////////////////////////////////////////////////////////
   	// the jumping animation
		if(MY._MOVEMODE == _MODE_JUMPING)
		{
			// calculate a percentage out of the animation time
			temp =  100 * MY._ANIMDIST / anim_jump_ticks;
			// set the frame from the percentage
			// -old- set_frame ME,anim_jump_str,temp;
			ent_frame(anim_jump_str,temp);
			// increment _ANIMDIST by elapsed time
			MY._ANIMDIST += TIME;
			// check to see if we finished jump animation
			if(MY._ANIMDIST > anim_jump_ticks)
			{
				MY._ANIMDIST = 0;
				MY._MOVEMODE = _MODE_WALKING;
			}
			return;
		}

   	// the ducking animation
		if(MY._MOVEMODE == _MODE_DUCKING)
		{
   		// you can only duck at walking speeds or below.
			if(my_dist >= walk_or_run*TIME*movement_scale)	// to fast to duck?
			{
				MY._MOVEMODE = _MODE_WALKING; // catch the walking mode below this one
 			}
			else
			{ // ducking
				// calculate a percentage out of the animation time
				temp =  100 * MY._ANIMDIST / anim_duck_ticks;
				// set the frame from the percentage
				// -old - set_frame ME,anim_duck_str,temp;
				ent_frame(anim_duck_str,temp);
				// increment _ANIMDIST by elapsed time
				MY._ANIMDIST += TIME;
				// check to see if we finished ducking
				if(MY._ANIMDIST > anim_duck_ticks)
				{
					MY._ANIMDIST = 0;
					MY._MOVEMODE = _MODE_CRAWLING;
				}
				return;
			}
		}

		// the crawling animation
		if(MY._MOVEMODE == _MODE_CRAWLING)
		{

			// you can only crawl at walking speeds or below.
			if(my_dist >= walk_or_run*TIME*movement_scale)	// to fast to crawl?
			{
				MY._MOVEMODE = _MODE_WALKING; // catch the walking mode below this one
 			}
			else
			{ // crawling
 				// set the distance covered, in percent of the model width
				covered_dist = MY._WALKDIST + my_dist / (MY.MAX_X-MY.MIN_X);
 				// calculate the real cycle distance from the model size
				while(covered_dist > anim_crawl_dist)
				{
					covered_dist -= anim_crawl_dist;
				}

				if(force.X < 0)	// moving backwards?
				{
					temp = 100 - temp;
				}
				temp = 100 * covered_dist / anim_crawl_dist;
				//-old- set_cycle ME,anim_crawl_str,temp;
				ent_cycle(anim_crawl_str,temp);

				MY._WALKDIST = covered_dist;     // save for next 'frame' of animation
				return;
			}

		}

		// the swimming animation
		if(MY._MOVEMODE == _MODE_SWIMMING)
		{
 			// set the distance covered, in percent of the model width
			covered_dist = MY._WALKDIST + my_dist / (MY.MAX_X-MY.MIN_X);
 			// calculate the real cycle distance from the model size
			while(covered_dist > anim_swim_dist)
			{
				covered_dist -= anim_swim_dist;
			}

			if(force.X < 0)	// moving backwards?
			{
				temp = 100 - temp;
			}
			temp = 100 * covered_dist / anim_swim_dist;
			// -old- set_cycle ME,anim_swim_str,temp;
			ent_cycle(anim_swim_str,temp);

			MY._WALKDIST = covered_dist;     // save for next 'frame' of animation
			return;
		}


		// the wading animation
		if(MY._MOVEMODE == _MODE_WADING)
		{
 			// set the distance covered, in percent of the model width
			covered_dist = MY._WALKDIST + my_dist / (MY.MAX_X-MY.MIN_X);
 			// calculate the real cycle distance from the model size
			while(covered_dist > anim_wade_dist)
			{
				covered_dist -= anim_wade_dist;
			}

			if(force.X < 0)	// moving backwards?
			{
				temp = 100 - temp;
			}

			temp = 100 * covered_dist / anim_wade_dist;
			// -old- set_cycle ME,anim_wade_str,temp;
			ent_cycle(anim_wade_str,temp);

			MY._WALKDIST = covered_dist;     // save for next 'frame' of animation
			return;
		}

		// the standing still animation
		// NOTE: the must be *before* _MODE_WALKING but after any other mode
		//      that can animate while the player is not moving (swimming,
		//		  ducking, jumping, etc.)
		if((my_dist < 0.01) || (MY._MOVEMODE == _MODE_STILL))
		{
 			MY._ANIMDIST += TIME;
			// wrap animation time to a value between zero and anim_stand_ticks
			if(MY._ANIMDIST > anim_stand_ticks)
			{
				MY._ANIMDIST -= anim_stand_ticks;
			}
			// calculate a percentage out of the animation time
			temp =  100 * MY._ANIMDIST / anim_stand_ticks;
			// set the frame from the percentage
			// -old- set_cycle ME,anim_stand_str,temp;
			ent_cycle(anim_stand_str,temp);

			return;
 		}


		// walking animation
		if(MY._MOVEMODE == _MODE_WALKING)
		{
			// set the distance covered, in percent of the model width
			covered_dist = MY._WALKDIST + my_dist / (MY.MAX_X-MY.MIN_X);

			// decide whether to play the walk or run animation
			if(my_dist < walk_or_run*TIME*movement_scale)	// Walking
			{
				anim_dist = anim_walk_dist;
				anim_str = anim_walk_str;
			}
			else
			{ // running
				anim_dist = anim_run_dist;
				anim_str = anim_run_str;
			}

			// calculate the real cycle distance from the model size
			if(covered_dist > anim_dist)
			{
				covered_dist -= anim_dist;
			}


			temp = 100 * covered_dist / anim_dist;
			if(force.X < 0)	// moving backwards?
			{
				temp = 100 - temp;
			}

			ent_cycle(anim_str,temp);

			if (covered_dist < MY._WALKDIST)
			{
				_play_walksound();	// sound for right foot
			}
			if ((covered_dist > anim_dist*0.5) && (MY._WALKDIST < anim_dist*0.5))
			{
				_play_walksound();	// sound for left foot
			}
			MY._WALKDIST = covered_dist;
			return;
		}
		return;
		// END OF NEW STYLE ANIMATIONS (frame names)
	}

	if((MY._MOVEMODE == _MODE_STILL) || (my_dist < 0.01))
	{
		// if the entity has a standing animation, instead of just one frame,
		// place it here. Otherwise...
		MY.FRAME = 1;	// standing
		return;
	}


old_style_anim:
	if(MY._MOVEMODE == _MODE_WALKING)
	{
		// decide whether to play the walk or run animation
		if((MY._RUNFRAMES <= 0) || (my_dist < walk_or_run*TIME*movement_scale))	// Walking
		{
			if(MY.FRAME < 2) { MY.FRAME = 2; }

			MY.FRAME += MY._WALKDIST*my_dist;

			// this is one of the expert exceptions where you can use WHILE without WAIT!
			while(MY.FRAME >= 2 + MY._WALKFRAMES)
			{
				// sound for right foot
				if(MY.__SOUND == ON) { _play_walksound(); MY.__SOUND = OFF; }
				// cycle the animation
				MY.FRAME -= MY._WALKFRAMES;
			}

			if(MY.FRAME > 1 + MY._WALKFRAMES*0.5) {
				// sound for left foot
				if(MY.__SOUND == OFF) { _play_walksound(); MY.__SOUND = ON; }
			}

			if(MY.FRAME > 1 + MY._WALKFRAMES)
			{
				MY.NEXT_FRAME = 2;	// inbetween to the first walking frame
			}
			else
			{
				MY.NEXT_FRAME = 0;	// inbetween to the real next frame
			}
			return;
		}
		else
		{	// Running
			if(MY.FRAME < 2 + MY._WALKFRAMES) { MY.FRAME = 2 + MY._WALKFRAMES; }

			MY.FRAME += MY._RUNDIST*my_dist;

			while(MY.FRAME >= 2 + MY._WALKFRAMES + MY._RUNFRAMES)
			{
				if(MY.__SOUND == ON) { _play_walksound(); MY.__SOUND = OFF; }
				MY.FRAME -= MY._RUNFRAMES;
			}

			if(MY.FRAME > 1 + MY._WALKFRAMES + MY._RUNFRAMES*0.5)
			{
				if(MY.__SOUND == OFF) { _play_walksound(); MY.__SOUND = ON; }
			}

			if(MY.FRAME > 1 + MY._WALKFRAMES + MY._RUNFRAMES)
			{
				MY.NEXT_FRAME = 2 + MY._WALKFRAMES;
			}
			else
			{
				MY.NEXT_FRAME = 0;
			}

			return;
		}
	}
}

///////////////////////////////////////////////////////////////////////
// First person camera view
// This should be a client-only action!!
//
// Mod Date: 5/10/00 @ 954 Doug Poston
//           Added code to create 'under water' fog
// Mod Date: 5/15/00 @ 947 Doug Poston
//				 Added eye_height adjustment for ducking and crawling
// Mod Date: 5/22/00 Doug Poston
//				 Added TOUCH for underwater fog
// Mod Date: 6/5/00 Doug Poston
//				 Replaced TOUCH with ent_content() function
// Mod Date: 6/26/00 Doug Poston
//				 Modifed IF to accept Swimming at any height
// Mod Date: 11/13/00 DCP
//				 headwave only when 'on_passable_' && swimming
// Mod Date: 02/07/01 DCP
//           Check camera 'content' for swimming headbob (don't bob if
//			underwater, do if swimming on top)
//				 Removed swimming 'eye_height_down' value
//				 Change 'layout', grouped like actions together
function move_view_1st()
{
	if(_camera == 0) // If the camera does not move itself
	{
		// Position the camera

		CAMERA.DIAMETER = 0;		// make the camera passable
		CAMERA.GENIUS = player;	// don't display parts of ME
	  	CAMERA.X = player.X;    // place camera at player's location
		CAMERA.Y = player.Y;
		CAMERA.Z = player.Z + player.MIN_Z;  // start at 'feet', move up later...

		// Move the eye height up depending on the _MOVEMODE (start at feet)
 		if(player._MOVEMODE == _MODE_SWIMMING)
		{
			// adjust eye height for swimming
		  	CAMERA.Z += (player.MAX_Z-player.MIN_Z)*eye_height_swim;
		}
		else  // not swimming
		{

 			if((player._MOVEMODE == _MODE_DUCKING) || (player._MOVEMODE == _MODE_CRAWLING))
			{
				// adjust eye height for ducking and crawling
				CAMERA.Z += (player.MAX_Z-player.MIN_Z)*eye_height_duck;
			}
			else
			{
				// adjust eye height for 'normal' modes
				CAMERA.Z += (player.MAX_Z-player.MIN_Z)*eye_height_up;
			}
 		}

		CAMERA.PAN = player.PAN;
		CAMERA.TILT = player.TILT + head_angle.TILT;
		CAMERA.ROLL = player.ROLL;

		// Handle head-bob

		if(my_height < 5 || (player._MOVEMODE == _MODE_SWIMMING) )
		{
			// use
			headwave = sin(player_dist*walk_rate);

			if((player._MOVEMODE == 0)	// moving on client?
				|| (player._MOVEMODE == _MODE_WALKING))
			{
				// Play the right and left foot sound
				if(((headwave > 0) && (walkwave <= 0))
					|| ((headwave <= 0) && (walkwave > 0)))
				{
					play_sound(thud,30);
				}
				// head bobbing
				walkwave = headwave;
				headwave = walk_ampl*(abs(headwave)-0.5);
			}

			if((player._MOVEMODE == _MODE_SWIMMING) && (ent_content(NULL,CAMERA.x) != CONTENT_PASSABLE))//(on_passable_ == ON))
			{
				if((headwave > 0) && (walkwave <= 0))
				{
					play_sound(splash,30);
				}
				// in-water wave movement
				walkwave = headwave;
				headwave = wave_ampl*sin(TOTAL_TICKS*wave_rate);
				head_angle.TILT += 0.1*wave_ampl*sin(TOTAL_TICKS*wave_rate - 60);
			}
		} // END if(my_height < 5 || (player._MOVEMODE == _MODE_SWIMMING) )


		if(player.__BOB == ON) { CAMERA.Z += headwave;	}



// check to see if camera is located in a passable block and set fog color index
//jcl 07-22-00  old fog is saved
		if (ent_content(NULL,CAMERA.x) == CONTENT_PASSABLE)
		{
			if (FOG_COLOR != _FOG_UNDERWATER)
			{
				current_fog_index = FOG_COLOR;	// save old fog
				FOG_COLOR = _FOG_UNDERWATER;	// set fog color to underwater fog
			}
		}
		else
		{
			if (FOG_COLOR == _FOG_UNDERWATER)
			{
				// else restore current_fog_index
				FOG_COLOR = current_fog_index;
			}
		}

		person_3rd = 0;  // we are in first person mode

	} // END if(_camera == 0) // If the camera does not move itself
}

// Third person camera view
//
// Mod Data: 5/10/00 DCP
//           Added code to create 'under water' fog
// Mod Date: 5/22/00 Doug Poston
//				 Added TOUCH for underwater fog
// Mod Date: 6/5/00 DCP
//				 Replaced TOUCH with ent_content() function
// Mod Date: 8/28/00 DCP
//				 Replaced 4.205 function with modified 'Fly Level' function
// Mod Date: 2/07/01 DCP
//				 Adjusted eye height
// 			 Don't tilt camera if swimming
function move_view_3rd()
{
	if ((_camera == 0) && (player != NULL))
	{

 		CAMERA.DIAMETER = 0;		// make the camera passable
		CAMERA.genius = player;
		CAMERA.pan += 0.2 * ang(player.pan-CAMERA.pan);

		// tilt the camera differently if we are using a vehicle
 		if ( (player._MOVEMODE == _MODE_PLANE)
 			||(player._MOVEMODE == _MODE_CHOPPER))
 		{
 			CAMERA.tilt += 0.2 * ang(player.tilt-CAMERA.tilt);
 		}
		else
		{
			// walking, swimming etc.
			CAMERA.TILT = head_angle.TILT;

  		  	if((person_3rd < 1) && (camera_dist.Z == 0))	// switching to 3rd person
			{
				camera_dist.Z = -(player.MAX_Z-player.MIN_Z)*eye_height_up;//- player.MAX_Z;
			}


		}

		vec_set(temp,temp_cdist);      // temp = temp_cdist
		// don't tilt camera if swimming
		if(player._MOVEMODE == _MODE_SWIMMING)
		{
			temp2 = player.TILT;
			player.TILT = 0;
			vec_rotate(temp,player.PAN);
			player.TILT = temp2;
		}
		else
		{
			vec_rotate(temp,player.PAN);
		}
      CAMERA.X += 0.3*(player.X - temp.X - CAMERA.X);
      CAMERA.Y += 0.3*(player.Y - temp.Y - CAMERA.Y);
      CAMERA.Z += 0.3*(player.Z - temp.Z - CAMERA.Z);

 		// test if camera is IN_PASSABLE or IN_SOLID
		temp = ent_content(NULL,CAMERA.X);

		// if camera moved into a wall...
		if (temp == CONTENT_SOLID)
		{
			temp_cdist.X *= 0.7;	// place it closer to the player
			temp_cdist.Y *= 0.7;
			temp_cdist.Z *= 0.7;
		}
		else
		{
			temp_cdist.X += 0.2*(player.MAX_X + camera_dist.X - temp_cdist.X);
			temp_cdist.Y += 0.2*(player.MAX_Y + camera_dist.Y - temp_cdist.Y);
			temp_cdist.Z += 0.2*(player.MAX_Z + camera_dist.Z - temp_cdist.Z);
		}

		// check to see if camera is located in a passable block and set fog color index
		if (temp == CONTENT_PASSABLE)
		{
			if (FOG_COLOR != _FOG_UNDERWATER)
			{
				current_fog_index = FOG_COLOR;	// save old fog
				FOG_COLOR = _FOG_UNDERWATER; 		// set fog color to underwater fog
			}
		}
		else
		{
			if (FOG_COLOR == _FOG_UNDERWATER)
			{
				// else restore current_fog_index
				FOG_COLOR = current_fog_index;
			}
		}
		person_3rd = 1;
	}

}


function move_view()
{
	if(player == NULL) { player = ME; }	// this action needs the player synonym
	if(player == NULL) { return; }			// still no player -> can't work
	if(person_3rd > 0)
	{	// This skill should be local
		move_view_3rd();
	}
	else
	{
		move_view_1st();
	}
}

// Desc: create a shadow below the entity
ACTION drop_shadow
{
	if(VIDEO_DEPTH >= 16)
	{
		create(SHADOWSPRITE,MY.POS,move_shadow);
	}
	else
	{
		create(SHADOWFLAT,MY.POS,move_shadow);
	}
}

//	Desc: function used to move shadow
//
// Mod Date: 05/29/00
// 			Added check for swimming or wading (no shadow)
// Mod Date: 7/30/00 JCL
//				Made shadow darker + adapted to floor slope
// Mod Date: 11/9/00 DCP
//				Replaced sonar with trace()
function move_shadow()
{
	MY.flare = ON;
	MY.transparent = ON; //inverse alpha
	MY.passable = ON;
	MY.oriented = ON;
	MY.ambient = -100; // shadow should be totally black
	MY.unlit = ON;		 //(plus UNLIT flag in version 4.20)

	// scale the shadow so that it matches its master's (YOU) size
	MY.scale_x = (YOU.MAX_X - YOU.MIN_X)/(MY.MAX_X - MY.MIN_X);
	MY.scale_y = MY.scale_x * 0.8;
	MY.scale_z = 1.0;
	while(YOU != NULL)
	{
		if ((YOU.invisible == ON)
		|| (YOU._MOVEMODE == _MODE_SWIMMING)
		|| (YOU._MOVEMODE == _MODE_WADING))
		{
			MY.invisible = ON;
		}
		else
		{
			MY.invisible = OFF;
  			temp_ent = YOU;


			//-old-sonar temp_ent,500; // get height above the floor
			trace_mode = IGNORE_PASSENTS
			  	+ IGNORE_ME
			  	+ IGNORE_YOU
			  	+ IGNORE_MODELS;
			vec_set(vecFrom,YOU.X);
			vec_set(vecTo,vecFrom);
			vecTo.Z -= 500;
			result = trace(vecFrom,vecTo);

			YOU = temp_ent; // YOU (the entity itself) is changed by SONAR

			if(result > 0)
			{
				// place shadow 2 quants above the floor
				MY.z = YOU.z - RESULT + 2; //YOUR.min_z*/ + 2 - RESULT;
				MY.x = YOU.x;
				MY.y = YOU.y;
				MY.pan = YOU.pan;
				// adapt shadow orientation to floor slope
				if ((NORMAL.x != 0) || (NORMAL.y != 0))
				{ // we're on a slope
					// rotate the floor normal relative to the shadow
					vec_set(temp,nullvector); // set temp tilt and roll to 0
					temp.pan = -MY.PAN;
					vec_rotate(NORMAL,temp);
					// calculate the destination tilt and roll angles
					MY.tilt = 90-asin(NORMAL.x);
					MY.roll = -asin(NORMAL.y);
				}
				else
				{
					MY.tilt = 90; // set it flat onto the floor
					MY.roll = 0;
				}
			}
			else
			{
				MY.INVISIBLE = ON;
			}
		}
		wait(1);
	} // end while(YOU != NULL)
	remove(ME);
}


// Desc: Get key input from the player
//
// Set aforce & force values using player input (keyboard/mouse/joystick)
// Make sure these values are within limit
//
// Mod Date: 6/9/00 Doug Poston
//				changed from ACTION to function
function _player_intentions()
{
// Set the angular forces according to the player intentions
	aforce.PAN = -astrength.PAN*(KEY_FORCE.X+JOY_FORCE.X);
	aforce.TILT = astrength.TILT*(KEY_PGUP-KEY_PGDN);
	if(MOUSE_MODE == 0)
	{	// Mouse switched off?
		 aforce.PAN += -astrength.PAN*MOUSE_FORCE.X*mouseview;
		 aforce.TILT += astrength.TILT*MOUSE_FORCE.Y*mouseview;
	}
	aforce.ROLL = 0;
// Set ROLL force if ALT was pressed
	if(KEY_ALT != 0)
	{
		aforce.ROLL = aforce.PAN;
		aforce.PAN = 0;
	}
// Double the forces in case the player pressed SHIFT
	if(KEY_SHIFT != 0)
	{
		aforce.PAN += aforce.PAN;
		aforce.TILT += aforce.TILT;
		aforce.ROLL += aforce.ROLL;
	}
// Limit the forces in case the player
// pressed buttons, mouse and joystick simultaneously
	limit.PAN = 2*astrength.PAN;
	limit.TILT = 2*astrength.TILT;
	limit.ROLL = 2*astrength.ROLL;

	if(aforce.PAN > limit.PAN) {  aforce.PAN = limit.PAN; }
	if(aforce.PAN < -limit.PAN) {  aforce.PAN = -limit.PAN; }
	if(aforce.TILT > limit.TILT) {  aforce.TILT = limit.TILT; }
	if(aforce.TILT < -limit.TILT) {  aforce.TILT = -limit.TILT; }
	if(aforce.ROLL > limit.ROLL) {  aforce.ROLL = limit.ROLL; }
	if(aforce.ROLL < -limit.ROLL) {  aforce.ROLL = -limit.ROLL; }

// Set the cartesian forces according to the player intentions
	force.X = strength.X*(KEY_FORCE.Y+JOY_FORCE.Y);
	force.Y = strength.Y*(KEY_COMMA-KEY_PERIOD);
	force.Z = strength.Z*(KEY_HOME-KEY_END);
	if(MOUSE_MODE == 0)
	{	// Mouse switched off?
		force.X += strength.X*MOUSE_RIGHT*mouseview;
	}

// Double the forces in case the player pressed SHIFT
	if(KEY_SHIFT != 0)
	{
		force.X += force.X;
		force.Y += force.Y;
		force.Z += force.Z;
	}

// Limit the forces in case the player tried to cheat by
// operating buttons, mouse and joystick simultaneously
	limit.X = 2*strength.X;
	limit.Y = 2*strength.Y;
	limit.Z = 2*strength.Z;

	if(force.X > limit.X) {  force.X = limit.X; }
	if(force.X < -limit.X) { force.X = -limit.X; }
	if(force.Y > limit.Y) {  force.Y = limit.Y; }
	if(force.Y < -limit.Y) { force.Y = -limit.Y; }
	if(force.Z > limit.Z) {  force.Z = limit.Z; }
	if(force.Z < -limit.Z) { force.Z = -limit.Z; }
}

// Desc: set force and aforce values
//			these values come from _player_intentions (single player)
//		  or from the client (multiplayer)
//
//	Calls: _player_intentions
//
// Mod Date: 6/9/00 Doug Poston
//				changed to function
function _player_force()
{
	// If the camera does not move itself
	if (_camera == 0)
	{
		// multiplayer mode
		if (client_moving)
		{
			// get forces from server
			force.X = MY._FORCE_X;
			force.Y = MY._FORCE_Y;
			force.Z = MY._FORCE_Z;
			aforce.PAN = MY._AFORCE_PAN;
			aforce.TILT = MY._AFORCE_TILT;
			aforce.ROLL = MY._AFORCE_ROLL;
		}
		else
		{
			// get forces from user input
			_player_intentions();
		}

		aforce.PAN *= MY._FORCE;
		aforce.TILT *= MY._FORCE;
		aforce.ROLL *= MY._FORCE;
		force.X *= MY._FORCE;
		force.Y *= MY._FORCE;
		force.Z *= MY._FORCE;
	}
	else
	{ // player controls camera - set actor forces to zero
		aforce.PAN = 0;
		aforce.TILT = 0;
		aforce.ROLL = 0;
		force.X = 0;
		force.Y = 0;
		force.Z = 0;
	}
}


// Desc: used in multiplayer (client/server) games
//			set client_moving var to 1
//			take user input use that to adjust the 'player' forces
//			SEND player forces to the server
//       move the camera
//
// Call: _player_intentions
//			move_view
function client_move()
{
	client_moving = 1;
	while(1)
	{
		_player_intentions();// user key/mouse input sets force and aforce values

		// player created on the client?
		if (player)
		{
			player._FORCE_X = force.X;
			player._FORCE_Y = force.Y;
			player._FORCE_Z = force.Z;
			player._AFORCE_PAN = aforce.PAN;
			player._AFORCE_TILT = aforce.TILT;
			player._AFORCE_ROLL = aforce.ROLL;

			// send player forces to server
			SEND player._FORCE_X;
			SEND player._FORCE_Y;
			SEND player._FORCE_Z;
			SEND player._AFORCE_PAN;
			SEND player._AFORCE_TILT;
			SEND player._AFORCE_ROLL;


			// move the camera
			move_view();
		}
		wait(1);
	}
}

/////////////////////////////////////////////////////////////////////
function toggle_person()
{
	if(person_3rd > 0)
	{
		person_3rd = 0;
	}
	else
	{
		person_3rd = 0.5;
	}
}

/////////////////////////////////////////////////////////////////////
// Auxiliary actions


// Desc: scan for a surface below the ME entity
//       set my_floornormal vector to the normal of the surface
//			set my_height to the distance between ME.MIN_Z and the surface
//			set floorspeed to the X & Y speed of any platform ME is on.
//			set on_passable_, in_passable_, and in_solid_ to the 'offset SONAR'
//		values.
//
// Mod Date: 7/22/00 JCL
//       sets on_passable_, in_passable_, and in_solid_ values using the
//		"MY.Z += 16 SONAR" method.
//
// Mod Date: 11/9/00 DCP
//				Replaced sonars with trace()
//
// Mod Date: 02/08/01 DCP
//          Modified 'offset sonar' to calculate height when in water (no
//			longer uses the hull, assume swim animation is centered vertically).
function scan_floor()
{
	// -old- SONAR	ME,4000;
//jcl 1-14-01: forgotten IGNORE_SPRITES fixed
	trace_mode = IGNORE_SPRITES + IGNORE_PASSENTS + IGNORE_MODELS + USE_BOX + ACTIVATE_SONAR;
	vec_set(vecFrom,MY.x);
	vec_set(vecTo,MY.x);
	vecTo.z -= 4000;
	my_height = trace(vecFrom,vecTo);  // this is the same as SONAR MY,distance;

	// if the first sonar shows we are in_passable or on_passable...
	if((IN_PASSABLE == ON) || (ON_PASSABLE == ON))
	{
		// the entity can be completely or partially under water
//--		vecFrom.z += 16;		// displace me upwards by the hull size - now my hull is outside the water
		vecFrom.z += (MY.MAX_Z + MY.MIN_Z);// displace upwards by model's vertical center
		trace_mode = IGNORE_SPRITES + IGNORE_PASSENTS + IGNORE_MODELS;
		my_height_passable = trace(vecFrom,vecTo);

	}
	else
	{
		my_height_passable = 0;
	}

	// save SONAR values for later use
	on_passable_ = ON_PASSABLE;
	in_passable_ = IN_PASSABLE;
	in_solid_ = IN_SOLID;

	my_floornormal.X = NORMAL.X; 	// set my_floornormal to the normal of the surface
	my_floornormal.Y = NORMAL.Y;
	my_floornormal.Z = NORMAL.Z;
//	my_height = RESULT;       		// set my_height to the distance between entity's MIN_Z and surface

	my_floorspeed.X = 0; 			// reset floorspeed to zero
	my_floorspeed.Y = 0;

	// if the player is standing on a platform, move him with it
	if(YOU != NULL)
	{
		if(YOUR._TYPE == _TYPE_ELEVATOR)
		{
			my_floorspeed.X = YOUR._SPEED_X;
			my_floorspeed.Y = YOUR._SPEED_Y;
			// Z speed is not necessary - this is done by the height adaption
		}
	}
}

/////////////////////////////////////////////////////////////
// Desc: Calculate a position directly ahead of the camera
// Input:  p (distance)
// Output: MY_POS
function set_pos_ahead()
{
	temp.X = cos(CAMERA.PAN);
	temp.Y = sin(CAMERA.PAN);
	temp.Z = p*cos(CAMERA.TILT);
	MY_POS.X = CAMERA.X + temp.Z*temp.X;
	MY_POS.Y = CAMERA.Y + temp.Z*temp.Y;
	MY_POS.Z = CAMERA.Z + p*sin(CAMERA.TILT);
}

/////////////////////////////////////////////////////////////
// Desc: Calculate a 3d position relative to the camera angles
// Input:  MY_POS
// Output: MY_POS
// Mod Date: 6/9/00 Doug Poston
//				changed to function
function _set_pos_ahead_xyz()
{
	vec_rotate(MY_POS,CAMERA.PAN);
	if(person_3rd != 0)
	{
		MY_POS.X += player.X;
		MY_POS.Y += player.Y;
		MY_POS.Z += player.Z;
	}
	else
	{
		MY_POS.X += CAMERA.X;
		MY_POS.Y += CAMERA.Y;
		MY_POS.Z += CAMERA.Z;
	}
}

////////////////////////////////////////////////////////////////////////
// Desc: event action to indicate any event by resetting the event flag
//
// Mod Date: 6/9/00 Doug Poston
//				changed to function
function _setback()
{
	if(EVENT_TYPE == EVENT_BLOCK) { MY.ENABLE_BLOCK = OFF; }
	if(EVENT_TYPE == EVENT_ENTITY) { MY.ENABLE_ENTITY = OFF; }
	if(EVENT_TYPE == EVENT_STUCK) { MY.ENABLE_STUCK = OFF; }

	if(EVENT_TYPE == EVENT_PUSH) { MY.ENABLE_PUSH = OFF; }
	if(EVENT_TYPE == EVENT_IMPACT) { MY.ENABLE_IMPACT = OFF; }

	if(EVENT_TYPE == EVENT_DETECT) { MY.ENABLE_DETECT = OFF; }
	if(EVENT_TYPE == EVENT_SCAN) { MY.ENABLE_SCAN = OFF; }
	if(EVENT_TYPE == EVENT_SHOOT) { MY.ENABLE_SHOOT = OFF; }
	if(EVENT_TYPE == EVENT_TRIGGER) { MY.ENABLE_TRIGGER = OFF; }

	if(EVENT_TYPE == EVENT_TOUCH) { MY.ENABLE_TOUCH = OFF; }
	if(EVENT_TYPE == EVENT_RELEASE) { MY.ENABLE_RELEASE = OFF; }
	if(EVENT_TYPE == EVENT_CLICK) { MY.ENABLE_CLICK = OFF; }
}

// Mod Date: 6/9/00 Doug Poston
//				changed to function
function _beep() { BEEP; }

////////////////////////////////////////////////////////////////////////
// Handle action. Set to SPACE by default.
// Will operate doors or items within 200 quants.
var indicator = 0;

DEFINE _HANDLE,1;		// SCAN via space key
DEFINE _EXPLODE,2;	// SCAN by an explosion
DEFINE _GUNFIRE,3;	// SHOOT fired by a gun
DEFINE _WATCH,4;		// looking for an enemy
DEFINE _DETECTED,5;	// detected by an enemy
DEFINE _SHOOT1,6;		// shoot key pressed (not used yet)

ACTION handle
{
	if(player != NULL)
	{
		MY_POS.X = player.X;
		MY_POS.Y = player.Y;
		MY_POS.Z = player.Z;
		MY_ANGLE.PAN = player.PAN;
	}
	else
	{
		MY_POS.X = CAMERA.X;
		MY_POS.Y = CAMERA.Y;
		MY_POS.Z = CAMERA.Z;
		MY_ANGLE.PAN = CAMERA.PAN;
	}
	MY_ANGLE.TILT = CAMERA.TILT;
	scan_handle();
}

// Desc: scan a wide cone of 200 quants range
function scan_handle()
{
	temp.PAN = 120;
	temp.TILT = 180;
	temp.Z = 200;
	indicator = _HANDLE;
	scan(MY_POS,MY_ANGLE,temp);
}


// Desc: This action can be run by a player entity on the server
// 		It checks for receiving a handle signal, then performs a scan
function perform_handle()
{
	while(1)
	{
		if(MY._SIGNAL == _HANDLE)
		{	// client has pressed handle key
			MY.HIDDEN = ON;
			MY._SIGNAL = 0;				// reset it
			MY_POS.X = MY.X;
			MY_POS.Y = MY.Y;
			MY_POS.Z = MY.Z;
			MY_ANGLE.PAN = MY.PAN;
			MY_ANGLE.TILT = MY.TILT;
			scan_handle();
		}
		wait(1);
	}
}

function send_handle()
{
	if(player != NULL)
	{
		player._SIGNAL = _HANDLE;	// send command to perform a scan
		SEND player._SIGNAL;
	}
}
/////////////////////////////////////////////////////////////////////
ON_F7 toggle_person;

ON_SPACE send_handle;

/////////////////////////////////////////////////////////////////////


// Desc: set TARGET to a point in the map that appears under the mouse pointer
//			returns the distance to that point
//
// Modifies: vecTo, vecFrom, TARGET, NORMAL, YOU, TEX_NAME, TEX_LIGHT
// Returns: distance to TARGET (or 0 if NULL)
function mouse_to_level()
{
	vecFrom.X = MOUSE_POS.X;
	vecFrom.Y = MOUSE_POS.Y;
	vecFrom.Z = 10;
	vec_set(vecTo,vecFrom);
	vec_for_screen(vecFrom,CAMERA); // near point

	vecTo.Z = 5000;
	vec_for_screen(vecTo,CAMERA);   // far point

	return(trace(vecFrom,vecTo));  // trace a line between the two points
}




// Desc: attaches an entity that has the same origin and the same frame cycles
//
function attach_entity()
{
   MY.PASSABLE = ON;
   if(YOUR.SHADOW == ON) { MY.SHADOW = ON; }

   while(1)
   {
   	if(YOU == player && person_3rd == 0)
		{
      	MY.INVISIBLE = ON;
   	}
		else
		{
      	MY.INVISIBLE = OFF;
   	}

   	vec_set(my.x,you.x);
   	vec_set(my.pan,you.pan);
   	my.frame = you.frame;
   	my.next_frame = you.next_frame;
   	wait(1);
   }
}