BMAP spherep_map <spherep.bmp>;

PANEL sperep_panel
{
BMAP spherep_map;
LAYER 2;
FLAGS OVERLAY, REFRESH;
}
///////////////////////////////////////////////////////////////////////////////////
// Gamestudio test level
///////////////////////////////////////////////////////////////////////////////////
path	"..\\template";	// Path to templates subdirectory
include <movement.wdl>;	// libraries of WDL functions
include <messages.wdl>;
include <menu.wdl>;		// menu must be included BEFORE doors and weapons
include <particle.wdl>; // remove when you need no particles
include <doors.wdl>;		// remove when you need no doors
include <actors.wdl>;   // remove when you need no actors
include <weapons.wdl>;

////////////////////////realspawn - we've added the two important scripts after the basic includes
include <mypanels.wdl>;
include <war4.wdl>; 

/////////////////////////////////////////////////////////////////
// define a splash screen with the required A4/A5 logo
bmap splashmap = <logodark.bmp>; // the default A5 logo in templates
panel splashscreen { bmap = splashmap; flags = refresh,d3d; }

include <sphered.wdl>; // the menubar
////////////////////////////////////////////////////////////////////////////
// After engine start, the MAIN function is executed, so the 2-D engine
// can display pictures, logos, or AVI animations. To load
// a level, you must perform an explicit LOAD_LEVEL instruction.

function main()
{
Menubar_pan.visible = ON;
midi_vol = 100; // sets the music volume to 100(/100)
PLAY_SONG menu_mid, 100; // playes the song until you stop it
}


MUSIC testsong = <beet.mid>;

// play a song if volume was set at beginning
function start_song()
{
	wait(4);	// wait until LOAD_INFO has loaded the last volume setting
	if (midi_vol > 0) {
		play_song_once(testsong,66);
	}
}

///////////////////////////////////////////////////////////////////////////////////
// The engine starts in the resolution given by the variable
// VIDEO_MODE. It is possible to switch the resolution during
// gameplay using the SWITCH_VIDEO instruction.

DEFINE V320x200,1;
DEFINE V320x240,2;	// default mode
DEFINE V320x400,3;	// not supported by some adaptors
DEFINE V400x300,4;	// won't run on my desktop
DEFINE V512x384,5;	// won't run on my laptop
DEFINE V640x480,6;
DEFINE V800x600,7;
DEFINE V1024x768,8;	// You'll need either D3D, or a P2-666 for this
DEFINE V1280x960,9;
DEFINE V1600x1200,10;

var video_mode = V640x480;
var video_depth = 16;	// always D3D mode

function zoom_in() {
	CAMERA.ARC -= 5;
	CAMERA.ARC = max(CAMERA.ARC,10);
}

function zoom_out() {
	CAMERA.ARC += 5;
	CAMERA.ARC = min(CAMERA.ARC,120);
}

////////////////////////////////////////////////////////////////////////////
// Everything that moves is an ENTITY. Entities may be placed
// into the level, or may be created at runtime. There will be
// 3 types of entities supported:
//
// - Model Entities (MDL files) for animated actors or objects
// - Sprite Entities (PCX files) for animated actors, objects, or explosions
// - Block Entities (WMB files) for doors, platforms, buildings and the like
//
// Each entity has two functions: The main AI action, which initializes it and controls
// its behaviour, and a separate EVENT function, which is triggered on
// certain events, like being hit or being touched.

// attaches an entity that has the same origin and the same frame cycles
function attach_clone
{
	my.passable = on;
	if (you.shadow == on) { my.shadow = on; }
	while(1)
	{
		if (you == player && person_3rd == 0) {
			my.invisible = on;
		} else {
			my.invisible = off;
		}
		vec_set(my.x,you.x);
		vec_set(my.pan,you.pan);
		my.frame = you.frame;
		my.next_frame = you.next_frame;
		wait(1);
	}
}

synonym guard { type entity; }

action patrol_prog
{
	guard = me;
// first, set the entity properties
	my.fat = off;
	my.narrow = on;
	my._walkframes = 1;
	my._movemode = _mode_walking;
	my._force = 1.5;

// then, call all standard tasks the entity shall perform
	patrol_path();
	if (my.shadow == off) { drop_shadow(); }

// add an event: touching it with the mouse
	my.string1 = "walking\nguard";
	my.enable_touch = on;
	my.event = handle_touch;

// attach other entities - AFTER setting the patrol movement action
	create(<shield.mdl>,nullvector,attach_clone);
	create(<mace.mdl>,nullvector,attach_clone);

// a non-standard entity function - like disappering
// on pressing the [R] key - may be directly scripted here, like this:
//	while (1) {
//		if (KEY_R) { remove(ME); }
//		WAIT 1;
//	}
}



}


}

// Level entities move the same way, and use the same instructions
// like model or sprite entities. Also you don't have to bother
// about not crossing surfaces: Due to the Z buffering, all objects can
// touch or penetrate each other without visible errors.
//
// Use the CREATE instruction to create an entity at a given
// position, running a given action:

var drop_dist = 0;
var max_lights = 3;

function emit_fish()
{
// wait until the previous fish is far enough
	while (drop_dist != 0) { wait(1); }
	drop_dist = 60;
	p = drop_dist;
	set_pos_ahead();
// place an entity 60 quants ahead of player position
	create(<fish.mdl>,MY_POS,fly_ahead);
	waitt(8);
	drop_dist = 0;
}

// This is the entity's action. An entity can change its type,
// (so a model can become a sprite), can be attached to another
// entity, and can perform some move or AI instructions.

var tumblespeed[3] = 5, 0, 0;
var angles[3];

SOUND bumm = <bumm.wav>;

function my_event()
{
	if ((EVENT_TYPE == EVENT_BLOCK)
		|| (EVENT_TYPE == EVENT_ENTITY))
	{
		play_entsound(me,bumm,100);
// bounce off the wall
		TO_ANGLE angles,BOUNCE;
		MY.PAN = angles.PAN;
		MY.TILT = angles.TILT;
// emit particles
		scatter_init();
		emit(100,particle_pos,particle_scatter);
	}
}

ACTION fly_ahead
{
	MY.PAN = CAMERA.PAN;	// let it fly in view direction, like a bullet
	MY.ROLL = CAMERA.ROLL;
	MY.TILT = CAMERA.TILT;
	MY.EVENT = my_event;
	MY.ENABLE_BLOCK = ON;
	MY.ENABLE_ENTITY = ON;

	if	((VIDEO_DEPTH >= 16) || (max_lights > 0)) {
		MY.LIGHTRED = 50;
		MY.LIGHTGREEN = 50;
		MY.LIGHTBLUE = 255;
		MY.LIGHTRANGE = 200;
		max_lights -= 1;
	}

	while (1) {
		tumblespeed.X = 10;
		tumblespeed.Y = 0;
		tumblespeed.Z = 0;
		move(ME,tumblespeed,nullvector);
		wait(1);
	}
}

////////////////////////////////////////////////////////////////////////////
// The following defs control the sky movement

// A backdrop texture's horizontal size must be a power of 2;
// the vertical size does not matter
bmap mountain_map = <mount16.pcx>;
bmap sky1_map = <cloud9.pcx>,256,0,256,256;
bmap sky2_map = <cloud9.pcx>,0,0,256,256;

function init_environment()
{
	CAMERA.FOG = 70;	// rather thick fog in the fog room

	scene_map = mountain_map;	// backdrop overlay
	sky_map = sky1_map;
	cloud_map = sky2_map;
//	scene_nofilter = on;

	sky_speed.x = 1;
	sky_speed.y = 1.5;
	cloud_speed.x = 3;
	cloud_speed.y = 4.5;
	sky_scale = 0.5;
	sky_curve = 1;
	scene_field = 120;
	scene_angle.tilt = 0;
}


/////////////////////////////////////////////////////////////////

/////////////////////////////////////////////////////////////////
// The following definitions are for the WDFC window composer
// (available only with the professional edition)
// to define the start and exit window of the application.
WINDOW WINSTART
{
	TITLE			"GameStudio";
	SIZE			480,320;
	MODE			IMAGE;		// STANDARD;
	BG_COLOR		RGB(0,0,0);	// black
	FRAME			FTYP1,0,0,480,320;
//	BUTTON		BUTTON_START,SYS_DEFAULT,"Start",400,288,72,24;
	BUTTON		BUTTON_QUIT,SYS_DEFAULT,"Abort",400,288,72,24;
	TEXT_STDOUT	"Arial",RGB(255,0,0),10,10,460,280;
}

/* no exit window at all..
WINDOW WINEND
{
	TITLE			"Finished";
	SIZE			540,320;
	MODE	 		STANDARD;
	BG_COLOR		RGB(0,0,0);
	TEXT_STDOUT	"",RGB(255,40,40),10,20,520,270;

	SET FONT		"",RGB(0,255,255);
	TEXT			"Any key to exit",10,270;
}*/

/////////////////////////////////////////////////////////////////
//INCLUDE <debug.wdl>;

include <snowmap.wdl>;
include <exploder.wdl>;
ACTION player_prog
{
MY.NARROW = ON; // use narrow hull!
MY.FAT = OFF;
MY.TRIGGER_RANGE = 5;
MY._MOVEMODE = _MODE_WALKING;
MY._FORCE = 0.75;
MY._BANKING = -0.1;
SET MY.__STRAFE,ON;
SET MY.__BOB,ON;
SET MY.__TRIGGER,ON;
CALL player_walk;
CALL player_fight;
CALL drop_shadow;
} 


include <weapons2.wdl>;
}
SOUND whammy <nothing.wav>;
/////////////nothing
function speech_event()
{
IF (YOU == PLAYER)
{
MY.EVENT = NULL;
PLAY_SOUND, whammy, 70;
WAIT 1;
}
}
 
ACTION detect_entity
{
MY.ENABLE_TRIGGER = ON;
MY.TRIGGER_RANGE = 400; // talk range
MY.EVENT = speech_event;
}

bmap health_map = <health.pcx>; 

panel hbar_pan 
{ 
     hbar 10, 10, 230, health_map, 1, player._health; 
     flags = refresh, visible, overlay; 
} 




  