// Template file v4.23a (02/09/01)   @020901a
////////////////////////////////////////////////////////////////////////
// File: war.wdl
//		WDL prefabs for hostile entities
////////////////////////////////////////////////////////////////////////
// Mod Date: 8/22/00 DCP
//				Changed '_gib' function to take a parameter to determine
//			the number of pieces to create in the gib explosion.
// Mod Date: 8/31/00 DCP
//				Modified '_gib_action' function to scale absdist vector by movement_scale
//				Modified '_gib_action' function to scale the gibbits down by the actor_scale
// Mod Date: 10/31/00 DCP
//				Changed to 4.30 format
// Mod Date: 11/8/00 DCP
//          'attack_fire' & 'state_die': Replace set_frame with ent_frame
//
// Mod Date: 02/06/01 DCP
//		In 'fight_event':
//			Added wait before shoot command to remove 'Dangerous instruction error'
//	 	   Replaced SHOOT with trace()

////////////////////////////////////////////////////////////////////////
//
////////////////////////////////////////////////////////////////////////

//SOUND chainsaw, <chainsaw.wav>;

//DEFINE WAR_CHAT_ON;	// display 'thought' actions for the AIs
IFDEF WAR_CHAT_ON;
	STRING war_wait_str,"Waiting...";
	STRING war_attack_str,"Attacking!!!";
	STRING war_hunt_str,"Searching...";
	STRING war_escape_str,"Retreat!!!";
	STRING war_dead_str,"I have been undone!";
ENDIF;



//////////////////////////////////////////////////////////////////////
// WAR.WDL - fighting behaviour
///////////////////////////////////////////////////////////////////////
IFNDEF WAR_DEFS;
 DEFINE ACTOR_EXPLO,<explo+7.pcx>;
 DEFINE ACTOR_EXPLO_FRAMES,7;
ENDIF;

///////////////////////////////////////////////////////////////////////
var freeze_actors = 0;	// 1,2 for testing purposes


///////////////////////////////////////////////////////////////////////
DEFINE _STATE_WAIT,1;
DEFINE _STATE_ATTACK,2;
DEFINE _STATE_ESCAPE,3;
DEFINE _STATE_DIE,4;
DEFINE _STATE_FREEZE,4;
DEFINE _STATE_HUNT,6;

DEFINE _MUZZLE_VERT,SKILL32;

///////////////////////////////////////////////////////////////////////
SYNONYM test_actor { TYPE entity; }

SYNONYM ent_marker {TYPE ENTITY;}	// marker entity, used in hunting


STRING	robot_attack_str, "attack";	// attack frame names used by robot

ACTION robot_test
{
IFNDEF test;
	remove(ME);
	return;
ENDIF;

	test_actor = ME;
	MY._WALKFRAMES = 8.030;
	MY._RUNFRAMES = 4.050;
	MY._ATTACKFRAMES = 6;
	MY._DIEFRAMES = 1;
	MY._FORCE = 2;
	MY._FIREMODE = DAMAGE_SHOOT+FIRE_PARTICLE+HIT_FLASH+0.05;
	MY._HITMODE = HIT_GIB;//HIT_EXPLO;
	MY._WALKSOUND = _SOUND_ROBOT;
	drop_shadow();
	anim_init();
	actor_fight();
}

// Desc: Action for robot #1
//			Init values and call actor_fight
ACTION robot1
{
	MY._FORCE = 0.7;
	MY._FIREMODE = DAMAGE_EXPLODE+FIRE_BALL+HIT_EXPLO+BULLET_SMOKETRAIL+0.20;
	MY._HITMODE = 0;
	MY._WALKSOUND = _SOUND_ROBOT;
 	anim_init();
	drop_shadow();	// attach shadow to robot
	actor_fight();
//	if(MY.FLAG4 == ON) { CALL patrol; }
}


// Desc: Action for robot #2
//			Init values and call actor_fight
ACTION robot2
{
	MY._FORCE = 2;
	MY._FIREMODE = DAMAGE_SHOOT+0.05;//FIRE_PARTICLE+0.05;//HIT_FLASH+0.05;
	MY._HITMODE = HIT_GIB;//HIT_EXPLO;
	MY._WALKSOUND = _SOUND_ROBOT;
	anim_init();
	drop_shadow(); // attach shadow to robot
	actor_fight();
//	if(MY.FLAG4 == ON) { patrol(); }
//	create(<arrow.pcx>,MY.POS,_ROBOT_TEST_WATCHER);  // used to activate watcher drone
}


// Desc: Action for robot #3
//			Init values and call actor_fight
//
// NOTE: robot #3 removes itself from the game!
ACTION robot3
{
	remove(ME);
	return;

	MY._FORCE = 0.7;
	MY._FIREMODE = DAMAGE_EXPLODE+FIRE_BALL+HIT_EXPLO+BULLET_SMOKETRAIL+0.20;
	anim_init();
	drop_shadow();
	actor_fight();
//	if(MY.FLAG4 == ON) { patrol(); }
}


// Desc: Debugging utility, watches a ROBOT and sets flags using its values
//
// Mod Date: 7/11/00 DCP
//				removed tst_values
SYNONYM ent_test_watcher {TYPE ENTITY;}	// marker entity, used in hunting
function _ROBOT_TEST_WATCHER()
{
	MY.PASSABLE = ON;
//	MY.INVISIBLE = ON;
	MY.ENTITY1 = YOU;

	WHILE(MY.ENTITY1 != 0)
	{
		ent_test_watcher = MY.ENTITY1;
 //		tst_value_1 =  ent_test_watcher._STATE;
		wait(1);

	}
 //	tst_value_1 =  -1;

	remove(ME);
}
///////////////////////////////////////////////////////////////////////


// Desc: the wait state
//
//	Mod:	6/15/00	Doug Poston
//			Added call to actor_move
function state_wait()
{
IFDEF WAR_CHAT_ON;
msg.STRING = war_wait_str;
show_message();
ENDIF;

	MY._STATE = _STATE_WAIT;
	while(MY._STATE == _STATE_WAIT)
	{

		if(MY._HEALTH <= 0) { EXCLUSIVE_ENTITY; wait(1); BRANCH state_die; }        // no health? Die
		if(MY._HEALTH <= 30) { EXCLUSIVE_ENTITY; wait(1); BRANCH state_escape; }    // low health? Escape

		// scan for the player coming near
		temp.PAN = 180;
		temp.TILT = 180;
		temp.Z = 1000;
		indicator = _WATCH;
		scan(MY.POS,MY.ANGLE,temp);

		// if the player has been detected...
		if(MY._SIGNAL == _DETECTED)
		{
			MY._SIGNAL = 0;
			BRANCH state_attack;	// ATTACK!
		}
		force = 0;     // no force from this actor
		actor_move();	// react to outside forces (gravity, etc) even while waiting
		waitt(4);
	}
}

// Desc: The attack state
//
// Mod Date: 6/27/00 Doug Poston
//				Added longer (timed) waits in attack states
function state_attack()
{
	MY._STATE = _STATE_ATTACK;
IFDEF WAR_CHAT_ON;
msg.STRING = war_attack_str;
show_message();
ENDIF;
	MY._MOVEMODE = _MODE_ATTACK;	// stop patrolling etc.
	attack_transitions();      // branch to other states depending on values

	// fire and close distance
	while(MY._STATE == _STATE_ATTACK)
	{

		// fire two or three times
		MY._COUNTER = 1.5 + RANDOM(1);

 		// check to see if player is shootable,
 		if((attack_fire()) == -1)
 		{
 			// cannot see player
 		  	EXCLUSIVE_ENTITY; wait(1); BRANCH state_hunt;
 		}
		while(MY._COUNTER > 0) { wait(1); }	// don't continue until attack_fire is finished


		// walk towards player for one to three seconds
		MY._COUNTER = 16 + RANDOM(32);
		attack_approach();
		while(MY._COUNTER > 0) { wait(1); } // don't continue until attack_approach is finished
	}
}

// Desc: Use internal and external values to branch to other states
//
// Mod Date: 7/8/00 DCP
//				Added EXCLUSIVE_ENTITY before each BRANCH
function attack_transitions()
{
	while(MY._STATE == _STATE_ATTACK)
	{
		if(MY._HEALTH <= 0) { EXCLUSIVE_ENTITY; wait(1); BRANCH state_die; }    	// goto die state
		if(MY._HEALTH <= 30) { EXCLUSIVE_ENTITY; wait(1); BRANCH state_escape; }  // goto escape state
		if(freeze_actors > 0) { EXCLUSIVE_ENTITY; wait(1); BRANCH state_freeze; } // goto freeze state
		wait(1);
	}
}



//	Desc: attack the player:
//				-turn towards player
//				-check if entity can see the player
//				-play fire animation
//				-fire shot
//
// Mod Date: 5/9/00 @ 908 by Doug Poston
//           Modified to use new animation system (SET_CYCLE/FRAME)
// Mod Date: 10/24/00 DCP
//				 Added ent_vertex() to use the _WEAPON_VERT (skill32) to select a
//				vertex on the model to be used as the weapon muzzle point.
// Mod Date: 11/1/00 DCP
//				 Replaced SHOOT with trace()
// Mod Date: 11/8/00 DCP
//          Replace set_frame with ent_frame
function attack_fire()
{

	while((MY._STATE == _STATE_ATTACK) && (MY._COUNTER > 0))
	{
		// turn towards player
		temp.X = player.X - MY.X;
		temp.Y = player.Y - MY.Y;
		temp.Z = player.Z - MY.Z;
		vec_to_angle(MY_ANGLE,temp);
		force = MY._FORCE * 2;
		actor_turn();

		// watch out if player visible. If yes, then shoot at him
		indicator = _WATCH;
		//SHOOT MY.POS,player.POS;
		trace_mode = IGNORE_ME + IGNORE_PASSABLE + IGNORE_PASSENTS;
		trace(MY.POS,player.POS);

		if((RESULT > 0) && (YOU == player))	// spotted him!
		{
			// fire at player
			// 1) PLAY ATTACK ANIMATION
			// check for new animation format
			if(frc(MY._WALKFRAMES) == 0)
			{
				// reset entity's animation time to zero
				MY._ANIMDIST = 0;

				while(MY._ANIMDIST < 50)
				{
					wait(1);
 					// calculate a percentage out of the animation time
					MY._ANIMDIST += 8.0 * TIME;   // attack in ~1 second
					// set the frame from the percentage
	  				// -old- SET_FRAME	ME,robot_attack_str,MY._ANIMDIST;
					ent_frame(robot_attack_str,MY._ANIMDIST);
				}
			}// END NEW STYLE ATTACK ANIMATION
			//if(FRC(MY._WALKFRAMES) != 0)
			else  // OLD STYLE ATTACK ANIMATION
			{
				// play attack animation
				MY.FRAME = 1 + MY._WALKFRAMES + MY._RUNFRAMES + 1;   // set frame to start
				MY.NEXT_FRAME = 0;	// inbetween to the real next frame
				while(MY.FRAME > 1 + MY._WALKFRAMES + MY._RUNFRAMES + MY._ATTACKFRAMES)
				{
 			 		MY.FRAME += 0.4 * TIME;
				}
  				MY.FRAME = 1 + MY._WALKFRAMES + MY._RUNFRAMES + 1;  // end at start frame
			}// END OLD STYLE ATTACK ANIMATION

			// 2) fire shot
			damage = frc(MY._FIREMODE) * 100;
			fire_mode = MY._FIREMODE;
			if((fire_mode & MODE_DAMAGE) == DAMAGE_SHOOT)
			{
				shot_speed.X = 50;//500;
			}
			else
			{
				shot_speed.X = 50;//100;
			}
			shot_speed.Y = 0;
			shot_speed.Z = 0;
			MY_ANGLE.PAN = MY.PAN;	// TILT is already set from TO_ANGLE
			vec_rotate(shot_speed,MY_ANGLE);
			// now shot_speed points ahead

			// check to see if the model is using a muzzle vertice
			if(MY._MUZZLE_VERT == 0)
			{
				// default gun muzzle
				vec_set(gun_muzzle.X,MY.X);
 //				gun_muzzle.X = MY.X;
	//			gun_muzzle.Y = MY.Y;
	  //			gun_muzzle.Z = MY.Z;
			}
			else
			{
				ent_vertex(gun_muzzle.X,MY._MUZZLE_VERT);
			}
			gun_shot();
			play_entsound(ME,gun_wham,150);

			MY._COUNTER -= 1;
			if(frc(MY._WALKFRAMES) == 0)
			{
				// play the second half of the animation
 				while(MY._ANIMDIST < 100)
				{
					wait(1);
 					// calculate a percentage out of the animation time
					MY._ANIMDIST += 8.0 * TIME;   // attack in ~1 second
					// set the frame from the percentage
	  				// -old- SET_FRAME	ME,robot_attack_str,MY._ANIMDIST;
					ent_frame(robot_attack_str,MY._ANIMDIST);
				}
			}// END NEW STYLE ATTACK ANIMATION
		}// END if((RESULT > 0) && (YOU == player))
		else
		{
			MY._COUNTER = 0;
			return(-1);	// can not see player
		}
		waitt(4);	// space shots appart (so they don't hit each other!
	}// END  while((MY._STATE == _STATE_ATTACK) && (MY._COUNTER > 0))
}

// Desc: approach the player with random deviation
//			do not approach any closer then 50 units
//
//	Note: only rotates by PANning
//
//	Calls: actor_turn()
//			 actor_move()
//
// Mod Date: 10/24/00 DCP
//			Increased range that robot stops approaching player to 100 units (from 50)
function attack_approach()
{
	// calculate a direction to walk into
	temp.X = player.X - MY.X;
	temp.Y = player.Y - MY.Y;
	temp.Z = 0;
	TO_ANGLE MY_ANGLE,temp;
	// ADD random deviation angle
	MY._TARGET_PAN = MY_ANGLE.PAN - 15 + RANDOM(30);

	while((MY._STATE == _STATE_ATTACK) && (MY._COUNTER > 0))
	{
	// turn towards player
		MY_ANGLE.PAN = MY._TARGET_PAN;
		MY_ANGLE.TILT = 0;
		MY_ANGLE.ROLL = 0;
		force = MY._FORCE * 2;
		actor_turn();

		// walk towards him if not too close
		temp = (player.X - MY.X)*(player.X - MY.X)+(player.Y - MY.Y)*(player.Y - MY.Y);
		if(temp > 10000)  // 100^2
		{
			force = MY._FORCE;
			MY._MOVEMODE = _MODE_WALKING;
			actor_move();
		}

		wait(1);
		MY._COUNTER -= TIME;
	}
}

// low on health => try to run away
function state_escape()
{
IFDEF WAR_CHAT_ON;
msg.STRING = war_escape_str;
show_message();
ENDIF;
	MY._STATE = _STATE_ESCAPE;
	while(MY._STATE == _STATE_ESCAPE)
	{
		if(MY._HEALTH <= 0) {  EXCLUSIVE_ENTITY; wait(1); BRANCH state_die; }
		// turn away from player
		temp.X = MY.X - player.X;
		temp.Y = MY.Y - player.Y;
		temp.Z = MY.Z - player.Z;
		vec_to_angle(MY_ANGLE,temp);
		force = MY._FORCE * 6;
		actor_turn();

		force = MY._FORCE * 4;
		MY._MOVEMODE = _MODE_WALKING;
		actor_move();

		wait(1);
	}
}


// Desc: Die:
//				-stop moving
//				-stop scanning and shooting
//				-null out my.event
//				-play death animation
//				-become passable
//
// Mod Date: 5/8/00 @ 752 by Doug Poston
//           Modified to use new animation system (SET_CYCLE/FRAME)
//
// Mod Date: 11/8/00 DCP
//          Replace set_frame with ent_frame
//
//	Notes: Uses entity's _AMIMDIST value as a 'percent death' value (0 start, 100 end)
function state_die()
{
IFDEF WAR_CHAT_ON;
msg.STRING = war_dead_str;
show_message();
ENDIF;
	MY._MOVEMODE = 0;		// don't move anymore
	MY._STATE = _STATE_DIE;
	MY.ENABLE_SCAN = OFF;		// get deaf and blind
	MY.ENABLE_SHOOT = OFF;
	MY.EVENT = NULL;			// and don't react anymore

	// check if we have a marker...
	if(MY.ENTITY1 != 0)
	{
		// if so, remove it.
		remove(MY.ENTITY1);
	}

	// decide whether it's a frame number (old) or frame name (new) animation
	if(frc(MY._WALKFRAMES) == 0)
	{
		// reset entity's animation time to zero
		MY._ANIMDIST = 0;

		while(MY._ANIMDIST < 100)
		{
			wait(1);
 			// calculate a percentage out of the animation time
			MY._ANIMDIST += 5.0 * TIME;   // death in ~1.25 seconds
			// set the frame from the percentage
	  		// -old- SET_FRAME	ME,anim_death_str,MY._ANIMDIST;
			ent_frame(anim_death_str,MY._ANIMDIST);
		}
	}// END NEW STYLE DEATH ANIMATION
	else    // OLD STYLE ANIMATION
	{
		MY.FRAME = 1 + MY._WALKFRAMES + MY._RUNFRAMES + MY._ATTACKFRAMES + 1;
		MY.NEXT_FRAME = 0;	// inbetween to the real next frame
		while(MY.FRAME <= (1 + MY._WALKFRAMES + MY._RUNFRAMES + MY._ATTACKFRAMES + MY._DIEFRAMES))
		{
			wait(1);
			MY.FRAME += 0.7 * TIME;
		}

	}// END OLD STYLE ANIMATION


	// If entity explodes after death
	if((ME != player) && ((MY._HITMODE & MODE_HIT) == HIT_EXPLO))//(MY._HITMODE & HIT_EXPLO))
	{
		morph(ACTOR_EXPLO,ME);
		show_score += 100;
	  	MY._DIEFRAMES = ACTOR_EXPLO_FRAMES;
	  	BRANCH actor_explode;       // ends with the removal of this entity
	}

  	// If entity 'gibs' after death
	if((ME != player) && ((MY._HITMODE & MODE_HIT) == HIT_GIB))//(MY._HITMODE & HIT_GIB))
	{
	  	show_score += 100;
		_gib(25);             		// use new "gib" function
	  	BRANCH actor_explode;     // ends with the removal of this entity
		
	}
	MY.PASSABLE = ON;   // body remains
}




// Desc: used to "tag" the last know target location
//       "CREATE <arrow.pcx>, MY.POS, _last_know_target_loc;"
function _last_know_target_loc()
{
	YOUR.ENTITY1 = ME;
	MY.INVISIBLE = ON;
	MY.PASSABLE = ON;
}

// Desc: move to the entity1 location
function hunt_approach()
{
	ent_marker = MY.ENTITY1;
	// calculate a direction to walk into
	temp.X = ent_marker.X - MY.X;
	temp.Y = ent_marker.Y - MY.Y;
	temp.Z = ent_marker.Z - MY.Z;
	vec_to_angle(MY_ANGLE,temp);
	MY._TARGET_PAN = MY_ANGLE.PAN;

   // turn towards target
	MY_ANGLE.PAN = MY._TARGET_PAN;
	MY_ANGLE.TILT = 0;
	MY_ANGLE.ROLL = 0;
	force = MY._FORCE * 2;
	actor_turn();
	if(avoid_walls() == 1)		// avoid hitting walls
	{
		force = MY._FORCE * 4;
		actor_turn();
	}


	temp = (ent_marker.X - MY.X)*(ent_marker.X - MY.X)+(ent_marker.Y - MY.Y)*(ent_marker.Y - MY.Y);
	// walk towards target only if not too close
	if(temp < 100) // 10^2
	{
		remove(MY.ENTITY1);	// remove marker
		EXCLUSIVE_ENTITY;
		wait(1);
		BRANCH state_wait;	// branch to wait mode
	}

	// walk towards ent_marker
	force = MY._FORCE;
	MY._MOVEMODE = _MODE_WALKING;
	actor_move();

}


// Desc: avoid hitting walls
//
// Return: 1 if to close to a wall, o otherwise
function avoid_walls()
{
	// shoot a line between the entity and the target point
	SHOOT MY.POS, ent_marker.POS;

	IF((YOU != ent_marker) && (RESULT < 50))	// too close to a wall...
	{
		// angle away from the wall.
		temp.X = (TARGET.X + (100 * NORMAL.X)) - MY.X;
		temp.Y = (TARGET.Y + (100 * NORMAL.Y)) - MY.Y;
		temp.Z = MY.Z;
		TO_ANGLE MY_ANGLE, temp;
		RETURN(1);
 	}
	RETURN(0);
}


// Desc: follow a wall until you reach a corner
//
// NOTE: to-do (pathfind.wdl?)
function follow_wall()
{
	RETURN(0);
}

// Desc: Use internal and external values to branch to other states
//
// Mod Date: 7/8/00 DCP
//				Added EXCLUSIVE_ENTITY before every BRANCH
function hunt_transitions()
{
	while(MY._STATE == _STATE_HUNT)
	{
		// Check heath
		IF(MY._HEALTH <= 0) { EXCLUSIVE_ENTITY; wait(1); BRANCH state_die; }    	// goto die state
		IF(MY._HEALTH <= 30) { EXCLUSIVE_ENTITY; wait(1); BRANCH state_escape; }  // goto escape state

  		// scan for the player coming near
		temp.PAN = 180;
		temp.TILT = 180;
		temp.Z = 1000;
		indicator = _WATCH;
		SCAN	MY.POS,MY.ANGLE,temp;

		// if the player has been detected...
		if(MY._SIGNAL == _DETECTED)
		{
			MY._SIGNAL = 0;
			remove(MY.ENTITY1);
			EXCLUSIVE_ENTITY; wait(1); BRANCH state_attack;	// ATTACK!
		}

		// Check debug
		IF(freeze_actors > 0) { EXCLUSIVE_ENTITY; wait(1); BRANCH state_freeze; } // goto freeze state
		waitt(1);
	}
}

// Desc: if you lose your target, move towards its last know location while
//		  scanning.
function	state_hunt()
{
	MY._STATE = _STATE_HUNT;
IFDEF WAR_CHAT_ON;
msg.STRING = war_hunt_str;
show_message();
ENDIF;
	// create a "marker" at the last known player location
	create(<arrow.pcx>, PLAYER.POS, _last_know_target_loc);
	MY._MOVEMODE = _MODE_WALKING;	// stop patrolling etc.
	hunt_transitions();      // branch to other states depending on values

	while(MY._STATE == _STATE_HUNT)
	{
		// approach the marker
		hunt_approach();

		wait(1);
	}
}


// Desc: freeze in place
function state_freeze()
{
	MY._STATE = _STATE_FREEZE;
	MY._MOVEMODE = _MODE_STILL;	// stop patroilling etc.
	while(MY._STATE == _STATE_FREEZE)
	{
		if(freeze_actors > 1) { MY.PASSABLE = ON; }
		if(freeze_actors == 0) { BRANCH state_wait; }
		wait(1);
	}
}

////////////////////////////////////////////////////////////////////////

// Desc: take damage and detect player
//
// Mod: 02/06/01 DCP
//		Added wait before shoot command to remove 'Dangerous instruction error'
//	   Replaced SHOOT with trace()
function fight_event()
{
	if((EVENT_TYPE == EVENT_SCAN && indicator == _EXPLODE)
		|| (EVENT_TYPE == EVENT_SHOOT && indicator == _GUNFIRE))
	{
		MY._SIGNAL = _DETECTED;	// by shooting, player gives away his position

		if (indicator == _EXPLODE)
		{	// reduce damage according to distance
			damage *= ABS(range - RESULT)/range;
		}

		if(MY._ARMOR <= 0)
		{
			MY._HEALTH -= damage;
		}
		else
		{
			MY._ARMOR -= damage;
		}
		return;
	}

	if(EVENT_TYPE == EVENT_DETECT && YOU == player)
	{
		wait(1);	//fix for dangerous instruction
		indicator = _WATCH;
//---		SHOOT MY.POS,YOUR.POS;	// can player be seen from here?
		trace_mode = IGNORE_ME + IGNORE_PASSABLE + ACTIVATE_SHOOT;
		RESULT = trace(MY.POS,YOUR.POS); // if entity YOU was visible from MY position, its SHOOT event was triggered
		if((RESULT > 0) && (YOU == player)) // yes
		{
			MY._SIGNAL = _DETECTED;
		}
		return;
	}
}

// Desc: init actor for fighting and branch to the wait state
function actor_fight()
{
//	if(MY._ARMOR == 0) { MY._ARMOR = 100; }
	if(MY._HEALTH == 0) { MY._HEALTH = 100; }	// default health
	if(MY._FORCE == 0) { MY._FORCE = 1; }       // default force

	// Allow player to pass thru actor if frozen
	if(freeze_actors > 1) { MY.PASSABLE = ON; }

	MY._SIGNAL = 0;
	MY.ENABLE_SCAN = ON;
	MY.ENABLE_SHOOT = ON;
	MY.ENABLE_DETECT = ON;
	MY.EVENT = fight_event;

	BRANCH state_wait;
}


// PLAYER ACTIONS
///////////////////////////////////////////////////////////////////////
function player_fight()
{
	if(MY._HEALTH == 0) { MY._HEALTH = 100; }

	MY.ENABLE_SCAN = ON;
	MY.ENABLE_SHOOT = ON;
	MY.EVENT = fight_event;

	while(MY._HEALTH > 0)
	{
		if(MY._SIGNAL == _DETECTED) {	// Hit received?
			MY._SIGNAL = 0;	// reset the _signal skill
			if(person_3rd == 0) {
				player_shake(); }
		}
		wait(1);
	}

// Dead
	MY._HEALTH = 0;
	if(person_3rd == 0)
	{	// 1st person die action
		MY._MOVEMODE = 0;		// don't move anymore
		MY.EVENT = NULL;		// prevent health counting down
		player_tip();
		waitt(8);
		weapon_remove(); 	// let weapon disappear
	}
	else
	{
		weapon_remove();	// prevent dead player firing
		BRANCH state_die;
	}
}





// Desc: explode into x number of random models
//
// Mod Date: 8/22/00 DCP
//				Uses function parameter (numberOfParts) to determine
//			how many 'gib' parts to create
function	_gib(numberOfParts)
{
	temp = 0;
	while(temp < numberOfParts)
	{
		create(<gibbit.mdl>, MY.POS, _gib_action);
		temp += 1;
	}

}

// Desc: Init and animate a gib-bit
//
// Mod Date: 6/29/00 Doug Poston
//				Added rotation and alpha-fading
// Mod Date: 8/31/00 DCP
//				Scale absdist vector by movement_scale
//				Scale the gibbits down by the actor_scale
function _gib_action()
{
	// scall the bits down by the actor_scale amount
	vec_scale(MY.SCALE_X,actor_scale);

	// Init gib bit
	MY._SPEED_X = 25 * (RANDOM(10) - 5);    // -125 -> +125
	MY._SPEED_Y = 25 * (RANDOM(10) - 5);    // -125 -> +125
	MY._SPEED_Z = RANDOM(35) + 15;          // 15 -> 50

	MY._ASPEED_PAN = RANDOM(35) + 35;       // 35 -> 70
	MY._ASPEED_TILT = RANDOM(35) + 35;      // 35 -> 70
	MY._ASPEED_ROLL = RANDOM(35) + 35;      // 35 -> 70

	MY.ROLL = RANDOM(180);	// start with a random orientation
	MY.PAN = RANDOM(180);

	MY.PUSH = -1;	// allow user/enemys to push thru



	// Animate gib-bit
	MY.SKILL9 = RANDOM(50);
	while(MY.SKILL9 > -75)
	{
		abspeed[0] = MY._SPEED_X * TIME;
		abspeed[1] = MY._SPEED_Y * TIME;
		abspeed[2] = MY._SPEED_Z * TIME;

		MY.PAN += MY._ASPEED_PAN * TIME;
		MY.TILT += MY._ASPEED_TILT * TIME;
		MY.ROLL += MY._ASPEED_ROLL * TIME;

		vec_scale(absdist,movement_scale);	// scale absolute distance by movement_scale
		MOVE  ME,NULLSKILL,abspeed;

		IF(BOUNCE.Z)
		{
			MY._SPEED_Z = -(MY._SPEED_Z/2);
			if(MY._SPEED_Z < 0.25)
			{
				MY._SPEED_X = 0;
				MY._SPEED_Y = 0;
				MY._SPEED_Z = 0;
				MY._ASPEED_PAN = 0;
				MY._ASPEED_TILT = 0;
				MY._ASPEED_ROLL = 0;
			}
		}

		MY._SPEED_Z -= 2;
		MY.SKILL9 -= 1;

		wait(1);
	}


	// Fade out
	MY.transparent = ON;
	MY.alpha = 100;
	while(1)
	{
   	MY.alpha -= 5*time;
		if(MY.alpha <=0)
		{
			// remove
			remove(ME);
			return;
		}

   	wait(1);
	}
}