////////////////////////////////////////////////
// Gaehh's Fire pack - Fire and Spell Effects
////////////////////////////////////////////////


// ************* BITMAPS ***************

BMAP fire_map,<fire.tga>;
BMAP fireball_map,<fireball.tga>;
BMAP fireball2_map,<fireball2.tga>;
BMAP campfire_map,<spark.tga>;
BMAP rauch_map,<rauch.tga>;
BMAP blue1_map,<blue1.tga>;
BMAP blue2_map,<blue2.tga>;
BMAP green_map,<green2.pcx>;

// ************* GLOBAL VARIABLES ***************

var parray [1801]; // will be used as a 300*6 multi dimensional array
                   // each of the 300 entries will consist of: 0 = flag, 1 = x_pos, 2-5 = data slots
var ppoint = 0;    // points to the next free entry-slot, is set through searcharray()

var boom = 0; 	   // counter for explosion effects

// ************** SKILL USAGE ****************
// skill 7        size
// skill 8        rate / duration
// skill 10-12    pos
// skill 13       counter
// skill 14       points to the emitters array offset in parray[]

// *************** ARRAY FUNCTION **************

function sarray() {
	ppoint = 0;
	while (parray [ppoint*6] != 0) { ppoint += 1; }
}



// ******** FIRE ***********

action my_fire {
	sarray();	 						// look for free array slot
	if (ppoint >= 300) { END; }					// stop action if too many emitters already present
	my.skill14 = ppoint;						// set skill14 accordingly
	parray[my.skill14 * 6] = 1;					// set flag of the slot to occupied
	if (my.skill8 == 0) { my.skill8 = 4; }				// rate 0 defaults to 4
	if (my.skill7 == 0) { my.skill7 = 1; }				// size 0 defaults to 1
	if (my.skill7 < 0.2 && my.skill7 != -1) { my.skill7 = 0.2; }	// check size values and correct them
	if (my.skill7 > 3) { my.skill7 = 3; }
	while(1) {							// fire burns forever
		if (my.skill7 > 0) {					// check if fire is turned ON
			my.skill13 -= 1;				// decrease emit counter
			if (my.skill13 <= 0) {
				my.skill13 = my.skill8 / TIME;					// set counter according to skill8

				parray[my.skill14 * 6 +2] = my.skill7;				// set size value in array

				parray[my.skill14 * 6 +1] = my.x + (random(4) - 2) * my.skill7;	// set pos.x value in array
				my.skill10 = my.skill14;					// array pointer stored in x_pos
				my.skill11 = my.y + (random(4) - 2) * my.skill7;		// set pos.y for emit
				my.skill12 = my.z;						// set pos.z for emit
				emit(1,my.skill10,feuer_particle);				// emit particle

				parray[my.skill14 * 6 +1] = my.x + (random(4) - 2) * my.skill7;	// set new pos.x
				my.skill11 = my.y + (random(4) - 2) * my.skill7;		// set new pos.y
				emit(1,my.skill10,feuer_particle);				// emit second particle
			}
		}
		wait(1);
	}
}


function feuer_particle(){
	if(my_age == 0)	{
		my_alpha = 0;						// set to invisible at start
		my_color.blue = parray[my_pos.x * 6 + 2];		// get size from array
		my_pos.x = parray[my_pos.x * 6 + 1];			// restore real pos.x
		my_speed.z = (0.7+random(0.4)) * my_color.blue;		// set speed.z
		my_color.red = random (100);				// set some random values
		my_color.green = random (100);
		my_size = (1000+random(300)) * my_color.blue;		// set size
		my_map = fire_map;					// set map
		my_flare = on;						// set to transparent (my_transparent seems to be buggy on some graphics cards
		my_bright= on;						// set my_bright to achieve the gloving effect
		END;
	}
 	if (my_age > 30) {						// kill particle if too old
			MY_ACTION = NULL;
	}
	if (my_age > 7) {						// set alpha according to age
		my_alpha = 100-MY_AGE*3.3;
	} else { my_alpha = my_age * 10; }

	my_speed.x = (sin(my_age*7+my_color.red) / 7) * my_color.blue;	// play with speed values
	my_speed.y = (cos(my_age*8+my_color.green) / 7) * my_color.blue;
}


// ************** SMOKE ****************

action my_smoke {
	sarray();	 						// look for free array slot
	if (ppoint >= 300) { END; }					// stop action if too many emitters already present
	my.skill14 = ppoint;						// set skill14 accordingly
	parray[my.skill14 * 6] = 1;					// set flag of the slot to occupied
	if (my.skill8 == 0) { my.skill8 = 4; }				// rate 0 defaults to 4
	if (my.skill7 == 0) { my.skill7 = 1; }				// size 0 defaults to 1
	if (my.skill7 < 0.2 && my.skill7 != -1) { my.skill7 = 0.2; }	// check size values and correct them
	if (my.skill7 > 3) { my.skill7 = 3; }
	while(1) {							// smokes forever
		if (my.skill7 > 0) {					// check if effect is turned ON
			my.skill13 -= 1;				// decrease emit counter
			if (my.skill13 <= 0) {
				my.skill13 = my.skill8 / TIME;					// set counter according to skill8

				parray[my.skill14 * 6 +2] = my.skill7;				// set size value in array
				parray[my.skill14 * 6 +1] = my.x + (random(4) - 2) * my.skill7;	// set pos.x value in array
				my.skill10 = my.skill14;					// array pointer stored in x_pos
				my.skill11 = my.y + (random(4) - 2) * my.skill7;		// set pos.y for emit
				my.skill12 = my.z;						// set pos.z for emit
				emit(1,my.skill10,smoke_particle);				// emit particle
			}
		}
		wait(1);
	}
}

function smoke_particle(){
	if(my_age == 0)	{
		my_alpha = 0;						// set to invisible at start
		my_color.blue = parray[my_pos.x * 6 + 2];		// get size from array
		my_pos.x = parray[my_pos.x * 6 + 1];			// restore real pos.x
		my_speed.z = (0.7+random(1)) * my_color.blue;		// set speed.z
		my_color.red = random (80);				// set random values
		my_color.green = random (80);
		my_size = (1100+random(200)) * my_color.blue;		// set size
		my_map = rauch_map;
		my_flare = on;						// set transparency
		END;
	}
 	if (my_age > 80) {			// kill if too old
			MY_ACTION = NULL;
	}
	if (my_age > 17) {						// set alpha according to age
		my_alpha = 40 - my_age/2;
	} else { my_alpha = my_age * 2; }
	my_speed.x = (sin(my_age * 6 + my_color.red) / 2.5) * my_color.blue;	// movement
	my_speed.y = (cos(my_age * 7 + my_color.green) / 2) * my_color.blue;
}




// ******** CAMPFIRE ***********

action my_campfire {
	sarray();	 						// look for free array slot
	if (ppoint >= 300) { END; }					// stop action if too many emitters already present
	my.skill14 = ppoint;						// set skill14 accordingly
	parray[my.skill14 * 6] = 1;					// set flag of the slot to occupied
	if (my.skill8 == 0) { my.skill8 = 2; }				// rate 0 defaults to 2
	if (my.skill7 == 0) { my.skill7 = 1; }				// size 0 defaults to 1
	if (my.skill7 < 0.2 && my.skill7 != -1) { my.skill7 = 0.2; }	// check size values and correct them
	if (my.skill7 > 3) { my.skill7 = 3; }
	while(1) {							// burns forever
		if (my.skill7 > 0) {					// check if effect is turned ON
			my.skill13 -= 1;
			if (my.skill13 <= 0) {								// counter
				my.skill13 = my.skill8 / TIME;						// set counter according to rate
				parray[my.skill14 * 6 +2] = my.skill7;					// set size value in array

				my.skill10 = my.skill14;						// store array offset
				parray[my.skill14 * 6 +1] = my.x + (random(8) - 4) * my.skill7;		// store pox.x
				my.skill11 = my.y + (random(8) - 4) * my.skill7;			// set pos.y
				my.skill12 = my.z;							// set pos.z
				emit(1,my.skill10,campfire_particle);					// emit inner fire particle
				parray[my.skill14 * 6 +1] = my.x + (random(9) - 4.5) * my.skill7;	// set pos.x
				my.skill11 = my.y + (random(9) - 4.5) * my.skill7;			// set pos.y
				emit(1,my.skill10,campfire2_particle);					// emit outer fire particle
				if (random(5) < 0.7) {							// random sparks
					parray[my.skill14 * 6 +1] = my.x + (random(9) - 4.5) * my.skill7;
					my.skill11 = my.y + (random(9) - 4.5) * my.skill7;
					emit(1,my.skill10,campfire3_particle);				// emit spark
				}
			}
		}
		wait(1);
	}
}

function campfire_particle(){
	if(my_age == 0)	{
		my_alpha = 0;						// set to invisible at start
		my_color.blue = parray[my_pos.x * 6 + 2];		// get size from array
		my_pos.x = parray[my_pos.x * 6 + 1];			// restore real pos.x
		my_speed.z = (0.6+random(0.4)) * my_color.blue;		// set speed.z
		my_color.red = random (100);				// random values for movement
		my_color.green = random (100);
		my_size = (700+random(700)) * my_color.blue;		// set size
		my_map = fire_map;					// set bitmap
		my_flare = on;
		my_bright= on;
		END;
	}
 	if (my_age > 25) {			// kill if too old
			MY_ACTION = NULL;
	}
	if (my_age > 5) {						// set alpha according to age
		my_alpha = 102-MY_AGE*4;
	} else { my_alpha = my_age * 14; }
	my_speed.x = (sin(my_age * 7 + my_color.red) / 5) * my_color.blue;	// movement
	my_speed.y = (cos(my_age * 8 + my_color.green) / 5) * my_color.blue;
}

function campfire2_particle(){
	if(my_age == 0)	{
		my_alpha = 0;						// same as campfire_particle, just some differing values
		my_color.blue = parray[my_pos.x * 6 + 2];
		my_pos.x = parray[my_pos.x * 6 + 1];
		my_speed.z = (0.6 + random(0.4)) * my_color.blue;
		my_color.red = random (100);
		my_color.green = random (100);
		my_size = (650 + random(500)) * my_color.blue;
		my_map = fire_map;
		my_flare = on;
		my_bright= on;
		END;
	}
 	if (my_age > 32) {
			MY_ACTION = NULL;
	}
	if (my_age > 5) {
		my_alpha = 102-MY_AGE*3;
	} else { my_alpha = my_age * 14; }
	my_speed.x = (sin(my_age * 7 + my_color.red) / 5) * my_color.blue;
	my_speed.y = (cos(my_age * 8 + my_color.green) / 5) * my_color.blue;
}

function campfire3_particle(){
	if(my_age == 0)	{
		my_alpha = 0;						// set to invisible at start
		my_color.blue = parray[my_pos.x * 6 + 2];		// get size from array
		my_pos.x = parray[my_pos.x * 6 + 1];			// restore real pos.x
		my_speed.z = (1.1 + random(0.4)) * my_color.blue;	// set speed.z
		my_size = 80 * my_color.blue;				// set size
		my_map = campfire_map;					// set bitmap
		my_flare = on;
		my_bright= on;
		END;
	}
 	if (my_age > 40) {			// kill if too old
			MY_ACTION = NULL;
	}
	if (my_age > 29) {						// set alpha depending on age
		my_alpha = 100-(MY_AGE-30)*9;
	} else { my_alpha = 100; }
	my_speed.x += (random (0.15) - 0.075) * my_color.blue;		// movement on random basis
	my_speed.y += (random (0.15) - 0.075) * my_color.blue;
}


// ******** PLASMA BALL ***********

action my_plasma {
	sarray();	 						// look for free array slot
	if (ppoint >= 300) { END; }					// stop action if too many emitters already present
	my.skill14 = ppoint;						// set skill14 accordingly
	parray[my.skill14 * 6] = 1;					// set flag of the slot to occupied
	if (my.skill8 == 0) { my.skill8 = 4; }				// rate 0 defaults to 4
	if (my.skill7 == 0) { my.skill7 = 1; }				// size 0 defaults to 1
	if (my.skill7 < 0.2 && my.skill7 != -1) { my.skill7 = 0.2; }	// check size values and correct them
	if (my.skill7 > 3) { my.skill7 = 3; }
	while(1) {							// fire burns forever
		if (my.skill7 > 0) {					// check if effect is turned ON
			my.skill13 -= 1;					// decrease emit counter
			if (my.skill13 <= 0) {
				my.skill13 = my.skill8 / TIME;					// set counter according to skill8

				parray[my.skill14 * 6 +2] = my.skill7;				// set size value in array

				parray[my.skill14 * 6 +1] = my.x + (random(4) - 2) * my.skill7;	// set pos.x value in array
				my.skill10 = my.skill14;					// array pointer stored in x_pos
				my.skill11 = my.y + (random(4) - 2) * my.skill7;		// set pos.y for emit
				my.skill12 = my.z + (random(4) - 2) * my.skill7;		// set pos.z for emit
				emit(1,my.skill10,plasma_particle);				// emit particle

				parray[my.skill14 * 6 +1] = my.x + (random(4) - 2) * my.skill7;	// set new pos.x
				my.skill11 = my.y + (random(4) - 2) * my.skill7;		// set new pos.y
				my.skill12 = my.z + (random(4) - 2) * my.skill7;		// set new pos.z
				emit(1,my.skill10,plasma_particle);				// emit second particle
			}
		}
		wait(1);
	}
}


function plasma_particle(){
	if(my_age == 0)	{
		my_alpha = 0;						// set to invisible at start
		my_color.blue = parray[my_pos.x * 6 + 2];		// get size from array
		my_pos.x = parray[my_pos.x * 6 + 1];			// restore real pos.x
		my_speed.x = (random(0.4) - 0.2) * my_color.blue;	// set speed.x
		my_speed.y = (random(0.4) - 0.2) * my_color.blue;	// set speed.y
		my_speed.z = (random(0.4) - 0.2) * my_color.blue;	// set speed.z
		my_size = (1000+random(300)) * my_color.blue;		// set size
		my_map = green_map;					// set map
		my_flare = on;						// set to transparent (my_transparent seems to be buggy on some graphics cards
		my_bright= on;						// set my_bright to achieve the gloving effect
		END;
	}
 	if (my_age > 30) {						// kill particle if too old
			MY_ACTION = NULL;
	}
	if (my_age > 7) {						// set alpha according to age
		my_alpha = 100-MY_AGE*3.3;
	} else { my_alpha = my_age * 10; }
}



// **************** EXPLOSION *******************

function my_explode(){
	create(<cube.mdl>,my.x,explode);		// create emitter
}

function my_explode2(){
	create(<cube.mdl>,my.x,explode2);		// create emitter
}

function my_explode3(){
	create(<cube.mdl>,my.x,explode3);		// create emitter
}

function explode(){
	my.invisible = ON;				// emitter invisible
	my.skill7 = your.skill7;			// get skill values from creating object
	my.skill8 = your.skill8;

	sarray();	 				// look for free array slot
	if (ppoint >= 300) { END; }			// stop action if too many emitters already present
	my.skill14 = ppoint;				// set skill14 accordingly
	parray[my.skill14 * 6] = 1;			// set flag of the slot to occupied
	if (my.skill8 == 0) { my.skill8 = 4; }		// rate 0 defaults to 10
	if (my.skill8 < 1) { my.skill8 = 1; }		// check rate values and correct them
	if (my.skill8 > 10) { my.skill8 = 10; }
	if (my.skill7 == 0) { my.skill7 = 1; }		// size 0 defaults to 1
	if (my.skill7 < 0.2) { my.skill7 = 0.2; }	// check size values and correct them
	if (my.skill7 > 3) { my.skill7 = 3; }
	my.skill13 = my.skill8 * 4;
	while ( my.skill13 > 0 ) {
		my.skill13 -= 1;

		parray[my.skill14 * 6 +2] = my.skill7;						// set size value in array
		my.skill10 = my.skill14;							// store array offset

		parray[my.skill14 * 6 +1] = my.x + (random(2) - 1) * my.skill7;			// store pos.x in array
		my.skill11 = my.y + (random(2) - 1) * my.skill7;				// set pos.y
		my.skill12 = my.z + (random(2) - 1) * my.skill7;				// set pos.z
		emit(1,my.skill10,explode_particle);						// emit particle

		parray[my.skill14 * 6 +1] = my.x + (random(4) - 2) * my.skill7;			// second particle
		my.skill11 = my.y + (random(4) - 2) * my.skill7;
		my.skill12 = my.z + (random(4) - 2) * my.skill7;
		emit(1,my.skill10,explode2_particle);

		if (random(2) > 0.8) {
			parray[my.skill14 * 6 +1] = my.x + (random(4) - 2) * my.skill7;			// third particle (trail)
			my.skill11 = my.y + (random(4) - 2) * my.skill7;
			my.skill12 = my.z + (random(4) - 2) * my.skill7;
			emit(1,my.skill10,explode3_particle);
		}

		wait (6);
	}
	parray[my.skill14 * 6] = 0;			// set flag of the slot to free
	remove (ME);					// destroy emitter object
}

function explode2(){
	my.invisible = ON;				// emitter invisible
	my.skill7 = your.skill7;			// get skill values from creating object
	my.skill8 = your.skill8;

	sarray();	 				// look for free array slot
	if (ppoint >= 300) { END; }			// stop action if too many emitters already present
	my.skill14 = ppoint;				// set skill14 accordingly
	parray[my.skill14 * 6] = 1;			// set flag of the slot to occupied
	if (my.skill8 == 0) { my.skill8 = 10; }		// rate 0 defaults to 10
	if (my.skill8 < 1) { my.skill8 = 1; }		// check rate values and correct them
	if (my.skill8 > 10) { my.skill8 = 10; }
	if (my.skill7 == 0) { my.skill7 = 1; }		// size 0 defaults to 1
	if (my.skill7 < 0.2) { my.skill7 = 0.2; }	// check size values and correct them
	if (my.skill7 > 3) { my.skill7 = 3; }
	my.skill13 = my.skill8 * 4;

	parray[my.skill14 * 6 +2] = my.skill7;						// set size value in array
	my.skill10 = my.skill14;							// store array offset
	parray[my.skill14 * 6 +1] = my.x + (random(2) - 1) * my.skill7;			// store pos.x in array
	my.skill11 = my.y + (random(2) - 1) * my.skill7;				// set pos.y
	my.skill12 = my.z + (random(2) - 1) * my.skill7;				// set pos.z
	emit(100,my.skill10,explode5_particle);						// emit shockwave

	while ( my.skill13 > 0 ) {
		my.skill13 -= 1;

		parray[my.skill14 * 6 +1] = my.x + (random(2) - 1) * my.skill7;			// store pos.x in array
		my.skill11 = my.y + (random(2) - 1) * my.skill7;				// set pos.y
		my.skill12 = my.z + (random(2) - 1) * my.skill7;				// set pos.z
		emit(1,my.skill10,explode_particle);						// emit particle

		parray[my.skill14 * 6 +1] = my.x + (random(4) - 2) * my.skill7;			// second particle
		my.skill11 = my.y + (random(4) - 2) * my.skill7;
		my.skill12 = my.z + (random(4) - 2) * my.skill7;
		emit(1,my.skill10,explode2_particle);

		if (random(2) > 0.8) {
			parray[my.skill14 * 6 +1] = my.x + (random(4) - 2) * my.skill7;			// third particle (trail)
			my.skill11 = my.y + (random(4) - 2) * my.skill7;
			my.skill12 = my.z + (random(4) - 2) * my.skill7;
			emit(1,my.skill10,explode3_particle);
		}

		wait (6);
	}
	parray[my.skill14 * 6] = 0;			// set flag of the slot to free
	remove (ME);					// destroy emitter object
}

function explode3(){
	my.invisible = ON;				// emitter invisible
	my.skill7 = your.skill7;			// get skill values from creating object
	my.skill8 = your.skill8;

	sarray();	 				// look for free array slot
	if (ppoint >= 300) { END; }			// stop action if too many emitters already present
	my.skill14 = ppoint;				// set skill14 accordingly
	parray[my.skill14 * 6] = 1;			// set flag of the slot to occupied
	if (my.skill8 == 0) { my.skill8 = 4; }		// rate 0 defaults to 10
	if (my.skill8 < 1) { my.skill8 = 1; }		// check rate values and correct them
	if (my.skill8 > 10) { my.skill8 = 10; }
	if (my.skill7 == 0) { my.skill7 = 1; }		// size 0 defaults to 1
	if (my.skill7 < 0.2) { my.skill7 = 0.2; }	// check size values and correct them
	if (my.skill7 > 3) { my.skill7 = 3; }
	my.skill13 = my.skill8 * 4;
	while ( my.skill13 > 0 ) {
		my.skill13 -= 1;

		parray[my.skill14 * 6 +2] = my.skill7;						// set size value in array
		my.skill10 = my.skill14;							// store array offset

		parray[my.skill14 * 6 +1] = my.x + (random(2) - 1) * my.skill7;			// store pos.x in array
		my.skill11 = my.y + (random(2) - 1) * my.skill7;				// set pos.y
		my.skill12 = my.z + (random(2) - 1) * my.skill7;				// set pos.z
		emit(1,my.skill10,explode_particle);						// emit particle

		parray[my.skill14 * 6 +1] = my.x + (random(4) - 2) * my.skill7;			// second particle
		my.skill11 = my.y + (random(4) - 2) * my.skill7;
		my.skill12 = my.z + (random(4) - 2) * my.skill7;
		emit(1,my.skill10,explode2_particle);

		wait (5);
	}
	parray[my.skill14 * 6] = 0;			// set flag of the slot to free
	remove (ME);					// destroy emitter object
}


function explode_particle(){
	if(my_age == 0)	{
		my_alpha = 0;						// set to invisible at start
		my_color.blue = parray[my_pos.x * 6 + 2];		// get size from array
		my_pos.x = parray[my_pos.x * 6 + 1];			// restore real pos.x
		my_speed.x = (random(1) - 0.5) * my_color.blue;		// set random speeds
		my_speed.y = (random(1) - 0.5) * my_color.blue;
		my_speed.z = (random(1) - 0.5) * my_color.blue;
		my_size = (900+random(400)) * my_color.blue;		// set size
		my_map = fireball_map;					// set bitmap
		my_flare = on;
		my_bright= on;
		END;
	}
 	if(MY_AGE > 40) {						// kill if too old;
			MY_ACTION = NULL;
	}
	if (my_age > 5) {						// set alpha according to age
		my_alpha = 82-MY_AGE*2;
	} else { my_alpha = 11 * MY_AGE; }
}

function explode2_particle(){
	if(my_age == 0)	{
		my_alpha = 0;						// similiar to explode_particle
		my_color.blue = parray[my_pos.x * 6 + 2];
		my_pos.x = parray[my_pos.x * 6 + 1];
		my_speed.x = (random(0.7) - 0.35) * my_color.blue;
		my_speed.y = (random(0.7) - 0.35) * my_color.blue;
		my_speed.z = (random(0.7) - 0.35) * my_color.blue;
		my_size = (500+random(400)) * my_color.blue;
		my_map = fireball_map;
		my_flare = on;
		my_bright= on;
		END;
	}
 	if((player == NULL) | | (MY_AGE > 40)) {
			MY_ACTION = NULL;
	}
	if (my_age > 5) {
		my_alpha = 82-MY_AGE*2;
	} else { my_alpha = 11 * MY_AGE; }
}

function explode3_particle(){
	if(my_age == 0)	{
		my_alpha = 0;						// set to invisible at start
		my_color.blue = parray[my_pos.x * 6 + 2];		// get size from array
		my_pos.x = parray[my_pos.x * 6 + 1];			// restore real pos.x
		sarray();	 					// look for free array slot
		if (ppoint >= 300) { END; }				// stop action if too many emitters already present
		my_color.green = ppoint;				// store offset
		parray[my_color.green * 6] = 1;				// set flag of the slot to occupied
		my_speed.x = (random(1.8) - 0.9) * my_color.blue;	// set random speeds
		my_speed.y = (random(1.8) - 0.9) * my_color.blue;
		my_speed.z = (random(1.8) - 0.5) * my_color.blue;
		my_size = (390 + random (50)) * my_color.blue;		// set size
		my_map = fireball_map;
		my_flare = on;
		my_bright= on;
		END;
	}
 	if (my_age > 35) {
			parray[my_color.green * 6] = 0;
			my_action = 0;
	}
	if (random(3) < 0.6 + TIME) {					// emit trail particle?
		parray[my_color.green * 6 + 2] = my_color.blue;		// size to array
		parray[my_color.green * 6 + 1] = my_pos.x;		// pos.x to array
		my_pos.x = my_color.green;				// store offset
		emit(1,my_pos,explode4_particle);			// emit
		my_pos.x = parray[my_color.green * 6 + 1];		// restore pos.x
	}
	my_speed.z -= (0.05 * TIME) * my_color.blue;			// gravity for trail
}

function explode4_particle(){
	if(my_age == 0)	{
		my_alpha = 0;						// set to invisible at start
		my_color.blue = parray[my_pos.x * 6 + 2];		// get size from array
		my_pos.x = parray[my_pos.x * 6 + 1];			// restore real pos.x
		my_speed.x = (random (0.2) - 0.1) * my_color.blue;	// set random speeds
		my_speed.y = (random (0.2) - 0.1) * my_color.blue;
		my_speed.z = (random (0.2) - 0.1) * my_color.blue;
		my_size = (300 + random(50)) * my_color.blue;
		my_map = fireball_map;					// set bitmap
		my_flare = on;
		my_bright= on;
		END;
	}
 	if (my_age > 15) {
			MY_ACTION = NULL;
	}
	if (my_age > 4) {						// set alpha according to speed
		my_alpha = 100 - my_age * 6;
	} else { my_alpha = 18 * my_age; }
}

function explode5_particle(){
	if(my_age == 0)	{
		my_alpha = 0;									// set to invisible at start
		my_color.blue = parray[my_pos.x * 6 + 2];					// get size from array
		my_pos.x = parray[my_pos.x * 6 + 1];						// restore real pos.x
		my_size = (320+random(120)) * my_color.blue;					// set size
		my_color.red = random (360);							// random pan value
		my_speed.x = ((sin (my_color.red) + random(0.1)) * 1.3) * my_color.blue;	// set speeds
		my_speed.y = ((cos (my_color.red) + random(0.1)) * 1.3) * my_color.blue;
		my_map = fireball_map;								// set bitmap
		my_flare = on;
		my_bright= on;
		END;
	}
 	if (MY_AGE > 40) {
			MY_ACTION = NULL;
	}
	if (my_age < 10) {
		my_alpha = my_age * 10;
	} else {
		my_alpha = 82 - my_age * 2;
	}
}

// ****************** TELEPORT SPELLS ***********************

// ****************** NR1

function my_teleporter(){
	create(<cube.mdl>,my.x,port_particle);		// create emitter
}

function port_particle(){
	my.invisible = ON;				// emitter is invisible

	my.skill7 = your.skill7;			// store size, rate and z-offset
	my.skill8 = your.skill8;
	my.z = my.z + your.skill6;
	sarray();	 				// look for free array slot
	if (ppoint >= 300) {				// stop action if too many emitters already present 
		remove(ME);
		END;  
	}
	my.skill14 = ppoint;				// set skill14 accordingly
	parray[my.skill14 * 6] = 1;			// set flag of the slot to occupied
	if (my.skill8 == 0) { my.skill8 = 6; }		// rate 0 defaults to 6
	if (my.skill8 < 4) { my.skill8 = 4; }		// check rate values and correct them
	if (my.skill8 > 10) { my.skill8 = 10; }

	if (my.skill7 == 0) { my.skill7 = 1; }		// size 0 defaults to 1
	if (my.skill7 < 0.2) { my.skill7 = 0.2; }	// check size values and correct them
	if (my.skill7 > 3) { my.skill7 = 3; }
	my.skill13 = my.skill8 * 14;			// set counter to initial value

	parray[my.skill14 * 6 +2] = my.skill7;							// set size value in array

	while ( my.skill13 > 0 ) {
		my.skill13 -= 1;

		my.skill1 = random (360);							// random pan for sin and cos
		my.skill10 = my.skill14;							// store array offset
		my.skill12 = my.z;

		if (random (17) < 1) {								// create flying particle ring on random occasions
			parray[my.skill14 * 6 + 3] = my.x;
			my.skill11 = my.y;
			emit(30,my.skill10,port4_particle);
		}

		parray[my.skill14 * 6 + 1] = my.x + (sin (my.skill1) * 30) * my.skill7;		// normal particle ring 
		my.skill11 = my.y + (cos (my.skill1) * 30) * my.skill7;

		emit(1,my.skill10,port2_particle);
		emit(1,my.skill10,port3_particle);

		my.skill1 = random (360);
		parray[my.skill14 * 6 + 4] = my.x + (sin (my.skill1) * 30) * my.skill7;
		my.skill11 = my.y + (cos (my.skill1) * 30) * my.skill7;
		emit(1,my.skill10,port2b_particle);

		my.skill1 = random (360);
		parray[my.skill14 * 6 + 5] = my.x + (sin (my.skill1) * 30) * my.skill7;
		my.skill11 = my.y + (cos (my.skill1) * 30) * my.skill7;
		emit(1,my.skill10,port2c_particle);

		waitt (3);
	}
	parray[my.skill14 * 6] = 0;			// set flag of the slot to free
	remove (ME);					// destroy emitter object
}


function port2_particle(){
	if(my_age == 0)	{
		my_alpha = 0;									// set to invisible at start
		my_color.blue = parray[my_pos.x * 6 + 2];					// get size from array
		my_pos.x = parray[my_pos.x * 6 + 1];						// restore real pos.x
		my_size = (700+random(200)) * my_color.blue;
		my_speed.x = (random (0.1)-0.05) * my_color.blue;
		my_speed.y = (random (0.1)-0.05) * my_color.blue;
		my_map = blue2_map;
		//my_transparent = on;
		my_flare = on;
		my_bright= on;
		END;
	}
 	if (my_age > 50) {
			MY_ACTION = NULL;
	}
	if (my_age < 10) {
		my_alpha = my_age * 10;
	} else {
		my_alpha = 100 - my_age * 2;
	}
}

function port2b_particle(){
	if(my_age == 0)	{
		my_alpha = 0;									// set to invisible at start
		my_color.blue = parray[my_pos.x * 6 + 2];					// get size from array
		my_pos.x = parray[my_pos.x * 6 + 4];						// restore real pos.x
		my_size = (700+random(200)) * my_color.blue;
		my_speed.x = (random (0.1)-0.05) * my_color.blue;
		my_speed.y = (random (0.1)-0.05) * my_color.blue;
		my_map = blue2_map;
		//my_transparent = on;
		my_flare = on;
		my_bright= on;
		END;
	}
 	if (my_age > 50) {
			MY_ACTION = NULL;
	}
	if (my_age < 10) {
		my_alpha = my_age * 10;
	} else {
		my_alpha = 100 - my_age * 2;
	}
}

function port2c_particle(){
	if(my_age == 0)	{
		my_alpha = 0;									// set to invisible at start
		my_color.blue = parray[my_pos.x * 6 + 2];					// get size from array
		my_pos.x = parray[my_pos.x * 6 + 5];						// restore real pos.x
		my_size = (700+random(200)) * my_color.blue;
		my_speed.x = (random (0.1)-0.05) * my_color.blue;
		my_speed.y = (random (0.1)-0.05) * my_color.blue;
		my_map = blue2_map;
		//my_transparent = on;
		my_flare = on;
		my_bright= on;
		END;
	}
 	if (my_age > 50) {
			MY_ACTION = NULL;
	}
	if (my_age < 10) {
		my_alpha = my_age * 10;
	} else {
		my_alpha = 100 - my_age * 2;
	}
}

function port3_particle(){
	if(my_age == 0)	{
		my_alpha = 0;									// set to invisible at start
		my_color.blue = parray[my_pos.x * 6 + 2];					// get size from array
		my_pos.x = parray[my_pos.x * 6 + 1];						// restore real pos.x
		my_size = (200+random(100)) * my_color.blue;
		my_speed.z = (random (0.2) + 0.2) * my_color.blue;
		my_map = blue1_map;
		//my_transparent = on;
		my_flare = on;
		my_bright= on;
		END;
	}
 	if (my_age > 40) {
			MY_ACTION = NULL;
	}
	if (my_age < 10) {
		my_alpha = my_age * 10;
	} else {
		my_alpha = 82 - my_age * 2;
	}
}

function port4_particle(){
	if(my_age == 0)	{
		my_alpha = 0;									// set to invisible at start
		my_color.blue = parray[my_pos.x * 6 + 2];					// get size from array
		my_pos.x = parray[my_pos.x * 6 + 3];						// restore real pos.x
		my_size = (200+random(100)) * my_color.blue;
		my_color.red = random (360);
		my_speed.x = (sin (my_color.red)) * my_color.blue;
		my_speed.y = (cos (my_color.red)) * my_color.blue;
		my_map = blue1_map;
		//my_transparent = on;
		my_flare = on;
		my_bright= on;
		END;
	}
 	if (my_age > 40) {
			MY_ACTION = NULL;
	}
	if (my_age < 10) {
		my_alpha = my_age * 10;
	} else {
		my_alpha = 82 - my_age * 2;
	}
}

// ****************** NR2
function my_teleporter2(){
	create(<cube.mdl>,my.x,port_particle2);		// create emitter
}

function port_particle2(){
	my.invisible = ON;				// emitter is invisible

	my.skill7 = your.skill7;			// store size, rate and z-offset
	my.skill8 = your.skill8;
	my.z = my.z + your.skill6;
	sarray();	 				// look for free array slot
	if (ppoint >= 300) {				// stop action if too many emitters already present 
		remove(ME);
		END;  
	}
	my.skill14 = ppoint;				// set skill14 accordingly
	parray[my.skill14 * 6] = 1;			// set flag of the slot to occupied
	if (my.skill8 == 0) { my.skill8 = 6; }		// rate 0 defaults to 6
	if (my.skill8 < 4) { my.skill8 = 4; }		// check rate values and correct them
	if (my.skill8 > 10) { my.skill8 = 10; }

	if (my.skill7 == 0) { my.skill7 = 1; }		// size 0 defaults to 1
	if (my.skill7 < 0.2) { my.skill7 = 0.2; }	// check size values and correct them
	if (my.skill7 > 3) { my.skill7 = 3; }
	my.skill13 = my.skill8 * 14;			// set counter to initial value

	parray[my.skill14 * 6 +2] = my.skill7;							// set size value in array

	while ( my.skill13 > 0 ) {
		my.skill13 -= 1;

		my.skill1 = random (180)-90;							// random pan for sin and cos
		my.skill10 = my.skill14;							// store array offset
		my.skill12 = my.z;

		parray[my.skill14 * 6 + 3] = my.x + (random(60) -30) * my.skill7;		// small particles at the bottom
		my.skill11 = my.y;
		emit(1,my.skill10,port4_particle2);

		parray[my.skill14 * 6 + 1] = my.x + (sin (my.skill1) * 30) * my.skill7;		// normal particle ring 
		my.skill11 = my.y;
		my.skill12 = my.z + (cos (my.skill1) * 75) * my.skill7;

		emit(2,my.skill10,port2_particle2);
		emit(1,my.skill10,port3_particle2);

		my.skill1 = random (180)-90;
		parray[my.skill14 * 6 + 4] = my.x + (sin (my.skill1) * 30) * my.skill7;
		my.skill12 = my.z + (cos (my.skill1) * 75) * my.skill7;
		emit(2,my.skill10,port2b_particle2);

		my.skill1 = random (180)-90;
		parray[my.skill14 * 6 + 5] = my.x + (sin (my.skill1) * 30) * my.skill7;
		my.skill12 = my.z + (cos (my.skill1) * 75) * my.skill7;
		emit(2,my.skill10,port2c_particle2);

		waitt (3);
	}
	parray[my.skill14 * 6] = 0;			// set flag of the slot to free
	remove (ME);					// destroy emitter object
}


function port2_particle2(){
	if(my_age == 0)	{
		my_alpha = 0;									// set to invisible at start
		my_color.blue = parray[my_pos.x * 6 + 2];					// get size from array
		my_pos.x = parray[my_pos.x * 6 + 1];						// restore real pos.x
		my_size = (700+random(200)) * my_color.blue;
		my_speed.x = (random (0.1)-0.05) * my_color.blue;
		my_speed.y = (random (0.1)-0.05) * my_color.blue;
		my_map = blue1_map;
		//my_transparent = on;
		my_flare = on;
		my_bright= on;
		END;
	}
 	if (my_age > 50) {
			MY_ACTION = NULL;
	}
	if (my_age < 10) {
		my_alpha = my_age * 10;
	} else {
		my_alpha = 100 - my_age * 2;
	}
}

function port2b_particle2(){
	if(my_age == 0)	{
		my_alpha = 0;									// set to invisible at start
		my_color.blue = parray[my_pos.x * 6 + 2];					// get size from array
		my_pos.x = parray[my_pos.x * 6 + 4];						// restore real pos.x
		my_size = (700+random(200)) * my_color.blue;
		my_speed.x = (random (0.1)-0.05) * my_color.blue;
		my_speed.y = (random (0.1)-0.05) * my_color.blue;
		my_map = blue1_map;
		//my_transparent = on;
		my_flare = on;
		my_bright= on;
		END;
	}
 	if (my_age > 80) {
			MY_ACTION = NULL;
	}
	if (my_age < 10) {
		my_alpha = my_age * 10;
	} else {
		my_alpha = 90 - my_age;
	}
}

function port2c_particle2(){
	if(my_age == 0)	{
		my_alpha = 0;									// set to invisible at start
		my_color.blue = parray[my_pos.x * 6 + 2];					// get size from array
		my_pos.x = parray[my_pos.x * 6 + 5];						// restore real pos.x
		my_size = (700+random(200)) * my_color.blue;
		my_speed.x = (random (0.1)-0.05) * my_color.blue;
		my_speed.y = (random (0.1)-0.05) * my_color.blue;
		my_speed.z = (random (0.3)-0.6) * my_color.blue;
		my_map = blue2_map;
		//my_transparent = on;
		my_flare = on;
		my_bright= on;
		END;
	}
 	if (my_age > 50) {
			MY_ACTION = NULL;
	}
	if (my_age < 10) {
		my_alpha = my_age * 10;
	} else {
		my_alpha = 100 - my_age * 2;
	}
}

function port3_particle2(){
	if(my_age == 0)	{
		my_alpha = 0;									// set to invisible at start
		my_color.blue = parray[my_pos.x * 6 + 2];					// get size from array
		my_pos.x = parray[my_pos.x * 6 + 1];						// restore real pos.x
		my_size = (200+random(100)) * my_color.blue;
		my_speed.z = (random (0.25) + 0.2) * my_color.blue;
		my_map = blue1_map;
		//my_transparent = on;
		my_flare = on;
		my_bright= on;
		END;
	}
 	if (my_age > 60) {
			MY_ACTION = NULL;
	}
	if (my_age < 10) {
		my_alpha = my_age * 10;
	} else {
		my_alpha = 92-MY_AGE*1.5;
	}
}

function port4_particle2(){
	if(my_age == 0)	{
		my_alpha = 0;									// set to invisible at start
		my_color.blue = parray[my_pos.x * 6 + 2];					// get size from array
		my_pos.x = parray[my_pos.x * 6 + 3];						// restore real pos.x
		my_size = (200+random(200)) * my_color.blue;
		my_speed.z = random(1) * my_color.blue; 
		my_map = blue1_map;
		//my_transparent = on;
		my_flare = on;
		my_bright= on;
		END;
	}
 	if (MY_AGE > 60) {
			MY_ACTION = NULL;
	}
	if (my_age < 10) {
		my_alpha = my_age * 10;
	} else {
		my_alpha = 82 - my_age * 1.5;
	}
}

// ******** FIREBALL ***********


function my_fireball(){
	sarray();	 				// look for free array slot
	if (ppoint >= 300) {				// stop action if too many emitters already present 
		remove(ME);
		END;  
	}
	my.skill14 = ppoint;				// set skill14 accordingly
	parray[my.skill14 * 6] = 1;			// set flag of the slot to occupied


	while (1) {
		if (my.skill7 == 0) { my.skill7 = 1; }		// size 0 defaults to 1
		if (my.skill7 < 0.2) { my.skill7 = 0.2; }	// check size values and correct them
		if (my.skill7 > 3) { my.skill7 = 3; }
		my.skill13 -= 1;
		if (my.skill13 <= 0) {				// counter
			my.skill13 = 2 / TIME;
	
			parray[my.skill14 * 6 +2] = my.skill7;					// set size value in array
			my.skill10 = my.skill14;						// store offset
			parray[my.skill14 * 6 + 1] = my.x + (random(2) - 1) * my.skill7;	// pos.x
			my.skill11 = my.y + (random(2) - 1) * my.skill7;			// pos.y
			my.skill12 = my.z + (random(2) - 1) * my.skill7;			// pos.z
			emit(1,my.skill10,fireball_particle);					// emit first particle

			parray[my.skill14 * 6 + 3] = my.x + (random(2) - 1) * my.skill7;	// new pos.x
			my.skill11 = my.y + (random(2) - 1) * my.skill7;			// new pos.y
			my.skill12 = my.z + (random(2) - 1) * my.skill7;			// new pos.z
			emit(1,my.skill10,fireball2_particle);					// emit 2nd particle
		}
	wait (1);
	}
}

function fireball_particle(){
	if(my_age == 0)	{
		my_alpha = 0;									// set to invisible at start
		my_color.blue = parray[my_pos.x * 6 + 2];					// get size from array
		my_pos.x = parray[my_pos.x * 6 + 1];						// restore real pos.x
		my_speed.x = (random(1.5) - 0.75) * my_color.blue;
		my_speed.y = (random(1.5) - 0.75) * my_color.blue;
		my_speed.z = (random(1.5) - 0.75) * my_color.blue;
		my_size = (500+random(900)) * my_color.blue;
		my_map = fireball_map;
		my_flare = on;
		my_bright= on;
		END;
	}
 	if (my_age > 12) {
			MY_ACTION = NULL;
	}
	if (my_age > 1) {
		my_alpha = 100-MY_AGE*8;
	} else { my_alpha = 40; }
}

function fireball2_particle(){
	if(my_age == 0)	{
		my_alpha = 0;									// set to invisible at start
		my_color.blue = parray[my_pos.x * 6 + 2];					// get size from array
		my_pos.x = parray[my_pos.x * 6 + 3];						// restore real pos.x
		my_speed.x = (random(1) - 0.5) * my_color.blue;
		my_speed.y = (random(1) - 0.5) * my_color.blue;
		my_speed.z = (random(1) - 0.5) * my_color.blue;
		my_size = (900+random(500)) * my_color.blue;
		my_map = fireball2_map;
		my_flare = on;
		my_bright= on;
		END;
	}
 	if (my_age > 10) {
			MY_ACTION = NULL;
	}
	if (my_age > 0) {
		my_alpha = 100-MY_AGE*9;
	} else { my_alpha = 50; }
}