///////////////////////////////////////////////////////////////////////////////////
// A4 main wdl
////////////////////////////////////////////////////////////////////////////
// The PATH keyword gives directories where game files can be found,
// relative to the level directory
PATH	"models";	// Path to model subdirectory - if any
PATH	"sounds";	// Path to sound subdirectory - if any
PATH	"bmaps";		// Path to graphics subdirectory - if any
PATH	"C:\\PROGRAMME\\GSTUDIO\\template";	// Path to WDL templates subdirectory

////////////////////////////////////////////////////////////////////////////
// The INCLUDE keyword can be used to include further WDL files,
// like those in the TEMPLATE subdirectory, with prefabricated actions
INCLUDE <movement.wdl>;
INCLUDE <messages.wdl>;
INCLUDE <particle.wdl>;
INCLUDE <doors.wdl>;
INCLUDE <actors.wdl>;
INCLUDE <weapons.wdl>;
INCLUDE <war.wdl>;
INCLUDE <menu.wdl>;

////////////////////////////////////////////////////////////////////////////
DEFINE V320x200 1;
DEFINE V320x240 2;	// default mode
DEFINE V320x400 3;	// not supported by many graphics adaptors
DEFINE V400x300 4;	// won't run on my desktop
DEFINE V512x384 5;	// won't run on my laptop
DEFINE V640x480 6;
DEFINE V800x600 7;
DEFINE V1024x768 8;
DEFINE V1280x960,9;
DEFINE V1600x1200,10;

// The engine starts in the resolution given by the following vars.
var video_mode = 8;
var fps_max = 95;
var video_depth = 16;	// start in 16 bit resolution
/////////////////////////////////////////////////////////////////
// The MAIN function is called at game start
function main()
{
	LOAD_LEVEL	<fireball.WMB>;
	load_status();	// restore global skills
//	client_move();	// for a possible multiplayer game
// call further functions here...
}

/////////////////////////////////////////////////////////////////
// The following definitions are for the pro edition window composer
// to define the start and exit window of the application.
WINDOW WINSTART
{
	TITLE			"A4 Engine";
	SIZE			480,320;
	MODE			IMAGE;	//STANDARD;
	BG_COLOR		RGB(240,240,240);
	FRAME			FTYP1,0,0,480,320;
//	BUTTON		BUTTON_START,SYS_DEFAULT,"Start",400,288,72,24;
	BUTTON		BUTTON_QUIT,SYS_DEFAULT,"Abort",400,288,72,24;
	TEXT_STDOUT	"Arial",RGB(0,0,0),10,10,460,280;
}

// ************* BITMAPS ***************

BMAP fireball_map,<fireball.tga>;
BMAP fireball2_map,<fireball2.tga>;


// ******** FIREBALL ***********


ACTION fireball_shot
{
	vec_scale(MY.SCALE_X,actor_scale);	// use actor_scale

	MY.ENABLE_BLOCK = ON;
	MY.ENABLE_ENTITY = ON;
	MY.ENABLE_STUCK = ON;
	MY.ENABLE_IMPACT = ON;
	MY.ENABLE_PUSH = ON;
	MY.EVENT = _fireball_event;

// *********** added for fireball:
	my.flare = ON;
	my.bright = ON;
	my.oriented = ON;
	my.alpha = 100;
	my.scale_x = 0.6;
	my.scale_y = 0.6;
	my.scale_z = 0.6;
// ***********
// *********** light values changed 
	MY.LIGHTRED = 100;
	MY.LIGHTGREEN = 50;
	MY.LIGHTBLUE = 20;
// ***********
	MY.LIGHTRANGE = 100;
	MY.AMBIENT = 100;

	MY.SKILL2 = shot_speed.x;
	MY.SKILL3 = shot_speed.y;
	MY.SKILL4 = shot_speed.z;
	MY._DAMAGE = damage;
	MY._FIREMODE = fire_mode;

  	// my.near is set by the explosion
	while(MY.NEAR != ON)
	{
		wait(1); // wait at the loop beginning, to let it appear at the start position
// *********** added flare rotation
		temp.X = player.X - MY.X;
		temp.Y = player.Y - MY.Y;
		temp.Z = player.Z - MY.Z;
		TO_ANGLE MY_ANGLE, temp;
		MY.PAN = MY_ANGLE.PAN;
		MY.TILT = MY_ANGLE.TILT;
		MY.ROLL -= 2*TIME;
// *********** added fire trail
		call my_fireball2;
		call my_fireball2;
		call my_fireball2;
		call my_fireball2;

		temp = TIME;
		if(temp > 1.5) { temp = 1.5; }	// make bullet slower on slow PCs
// *********** slow speed down
		temp = temp / 8;

// MOVE moves by a distance, so multiply the speed by time.

		fireball_speed.x = MY.SKILL2 * temp;
		fireball_speed.y = MY.SKILL3 * temp;
		fireball_speed.z = MY.SKILL4 * temp;

		vec_scale(fireball_speed,movement_scale);	// scale fireball_speed by movement_scale
 		move(ME,nullskill,fireball_speed);
	}
}

// ****************** fireball function without loop and scaling *****************
function my_fireball2(){
	if(player == NULL) { END; }
		my.skill10 = my.x + random(2) - 1;
		my.skill11 = my.y + random(2) - 1;
		my.skill12 = my.z + random(2) - 1;
		my.skill13 -= 1;
		if (my.skill13 <= 0) {
			my.skill13 = 2 / TIME;
			emit(1,my.skill10,fireball_particle2);
			my.skill10 = my.x + random(2) - 1;
			my.skill11 = my.y + random(2) - 1;
			my.skill12 = my.z + random(2) - 1;
			emit(1,my.skill10,fireball2_particle2);
		}
}

function fireball_particle2(){
	if(my_age == 0)	{
		my_alpha = 0;
		my_speed.x = random(1.5) - 0.75;
		my_speed.y = random(1.5) - 0.75;
		my_speed.z = random(1.5) - 0.75;
		my_size = 500+random(1200);
		my_map = fireball_map;
		//my_transparent = on;
		my_flare = on;
		my_bright= on;
		END;
	}
 	if((player == NULL) | | (MY_AGE > 12)) {
			MY_ACTION = NULL;
	}
	if (my_age > 1) {
		my_alpha = 100-MY_AGE*8;
	} else { my_alpha = my_age * 40; }
}

function fireball2_particle2(){
	if(my_age == 0)	{
		my_alpha = 0;
		my_speed.x = random(1) - 0.5;
		my_speed.y = random(1) - 0.5;
		my_speed.z = random(1) - 0.5;
		my_size = 1100+random(400);
		my_map = fireball2_map;
		//my_transparent = on;
		my_flare = on;
		my_bright= on;
		END;
	}
 	if((player == NULL) | | (MY_AGE > 10)) {
			MY_ACTION = NULL;
	}
	if (my_age > 0) {
		my_alpha = 100-MY_AGE*9;
	} else { my_alpha = 50; }
}

// ********************** function gunshot from weapons.wdl **************
function gun_shot()
{
	// select and handle shot type using 'fire_mode'

	// particle trail shot (line of particles)
	if((fire_mode & MODE_FIRE) == FIRE_PARTICLE)
	{
		vec_set(p,gun_muzzle);
		vec_set(p2,gun_target);
		particle_line();
	}

	// single particle
	if((fire_mode & MODE_FIRE) == FIRE_DPARTICLE)
	{ emit(1,gun_muzzle,particle_shot); }

	// fireball
	if((fire_mode & MODE_FIRE) == FIRE_BALL)
// *********************** replaced default fireball **************
	{ create(<flare.pcx>,gun_muzzle,fireball_shot); }
//	{ create(fireball,gun_muzzle,bullet_shot); }

	// rocket model
	if((fire_mode & MODE_FIRE) == FIRE_ROCKET)
	{ create(<rocket.mdl>,gun_muzzle,rocket_launch); }

	// eject brass?
	if((fire_mode & GUNFX_BRASS) != 0)
	{
	 	emit(1,gun_muzzle,particle_gunBrass); // emit smoke
	}


	// bullet damage is done with a trace
	if((fire_mode & MODE_DAMAGE) == DAMAGE_SHOOT)
	{
		// set gun_target
		gun_target.X = 2*shot_speed.X + gun_muzzle.X;
		gun_target.Y = 2*shot_speed.Y + gun_muzzle.Y;
		gun_target.Z = 2*shot_speed.Z + gun_muzzle.Z;

		if((fire_mode & HIT_SCATTER) != 0)	// scatter gun?
		{
			vec_set(_gun_shot_temp.X, gun_target.X);	// save base gun_target

			_gun_shot_sCount = 0;
			while(_gun_shot_sCount < scatter_number)
			{
				// offset each shot by a random amount
				gun_target.X = _gun_shot_temp.X + (Random(SCATTER_RAND)-SCATTER_HALF_RAND);
				gun_target.Y = _gun_shot_temp.Y + (Random(SCATTER_RAND)-SCATTER_HALF_RAND);
				gun_target.Z = _gun_shot_temp.Z + (Random(SCATTER_RAND)-SCATTER_HALF_RAND);
				_gun_shot_damage_shoot();
				_gun_shot_sCount += 1;
			}
			vec_set(gun_target.X, _gun_shot_temp.X);	// restore  gun_target
 		}
		else
		{
			// fire one shot
 			_gun_shot_damage_shoot();
		}

	}
}


// ****************** player action *********

action my_hero {
  MY._WALKFRAMES = 1;  // frame name based animation
  MY._ENTFORCE = 0.75; // speed
  MY._BANKING = -0.1;  // banking
  MY._MOVEMODE = _MODE_WALKING;
  MY.__JUMP = ON;   // jumping
  MY.__STRAFE = ON; // strafing
  MY.__BOB = ON;    // head bobbing
  MY.NARROW = ON;   // use narrow hull, so that he fits through smaller doors
  MY.FAT = OFF;
  MY._FIREMODE = DAMAGE_EXPLODE + FIRE_BALL + HIT_EXPLO;
  player_move();  // enable walking
  player_fight(); // enable fighting

}


/* no exit window at all..
WINDOW WINEND
{
	TITLE			"Finished";
	SIZE			540,320;
	MODE	 		STANDARD;
	BG_COLOR		RGB(0,0,0);
	TEXT_STDOUT	"",RGB(255,40,40),10,20,520,270;

	SET FONT		"",RGB(0,255,255);
	TEXT			"Any key to exit",10,270;
}*/



/////////////////////////////////////////////////////////////////
//INCLUDE <debug.wdl>;