//////////////////////////////////////////////////
// Fire Pack Tutorial Level
//////////////////////////////////////////////////


////////////////////////////////////////////////////////////////////
// The engine starts in the resolution given by the following vars.
var video_mode = 8;
var video_depth = 32;
////////////////////////////////////////////////////////////////////
// The MAIN function is called at game start
function main()
{
	load_level(<tut4.wmb>);
	_move_straight();	// predefined camera movement
}

BMAP fire_map,<fire.tga>;

action particle1{
	while(1) {						// fire burns forever
		my.skill13 -= 1;				// counter
		if (my.skill13 <= 0) {
			my.skill13 = my.skill8 / TIME;		// set counter to initial value
			my.skill10 = my.x + random(4) - 2;	// pos.x
			my.skill11 = my.y + random(4) - 2;	// pos.y
			my.skill12 = my.z;			// pos.z
			emit(1,my.skill10,test_particle1);	// emit particle
			my.skill10 = my.x + random(4) - 2;	// new pos.x
			my.skill11 = my.y + random(4) - 2;	// new pos.y
			emit(1,my.skill10,test_particle1);	// emit second particle
		}
		wait(1);
	}
}

function test_particle1(){
	if (my_age == 0)	{				// initialize particle
		my_alpha = 0;
		my_speed.z = 0.7 + random(0.4);			// speed.z
		my_color.red = random(150);			// random offset for sin function
		my_color.green = random(150);			// random offset for cos function
		my_size = 700 + random(300);			// set size
		my_map = fire_map;				// set bitmap
		my_flare = on;					// set transparency
		my_bright= on;					// set glowing effect
		END;
	}
 	if (my_age > 30) {					// kill if too old
			MY_ACTION = NULL;
	}
	if (my_age > 7) {					// set alpha according to age
		my_alpha = 91 - my_age * 3;
	} else { my_alpha = my_age * 10; }
	my_speed.x = sin(my_age * 7 + my_color.red) / 7;	// play with speed.x
	my_speed.y = cos(my_age * 8 + my_color.green) / 7;	// play with speed.y
}


/////////////////////////////////////////////////////////////////
//INCLUDE <debug.wdl>;